/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.TypeTokenFilter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class KeepTypesFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<String> keepTypes;
    private static final String KEEP_TYPES_KEY = "types";

    @Inject
    public KeepTypesFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String[] arrayKeepTypes = settings.getAsArray(KEEP_TYPES_KEY, null);
        if (arrayKeepTypes == null) {
            throw new ElasticsearchIllegalArgumentException("keep_types requires `types` to be configured");
        }
        this.keepTypes = new HashSet<String>(Arrays.asList(arrayKeepTypes));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new TypeTokenFilter(this.version, tokenStream, this.keepTypes, true);
    }
}

