/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.aliases;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.FilterClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.aliases.IndexAlias;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;

public class IndexAliasesService
extends AbstractIndexComponent
implements Iterable<IndexAlias> {
    private final IndexQueryParserService indexQueryParser;
    private final Map<String, IndexAlias> aliases = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    @Inject
    public IndexAliasesService(Index index, @IndexSettings Settings indexSettings, IndexQueryParserService indexQueryParser) {
        super(index, indexSettings);
        this.indexQueryParser = indexQueryParser;
    }

    public boolean hasAlias(String alias) {
        return this.aliases.containsKey(alias);
    }

    public IndexAlias alias(String alias) {
        return this.aliases.get(alias);
    }

    public IndexAlias create(String alias, @Nullable CompressedString filter) {
        return new IndexAlias(alias, filter, this.parse(alias, filter));
    }

    public void add(String alias, @Nullable CompressedString filter) {
        this.add(new IndexAlias(alias, filter, this.parse(alias, filter)));
    }

    public void addAll(Map<String, IndexAlias> aliases) {
        this.aliases.putAll(aliases);
    }

    public Filter aliasFilter(String ... aliases) {
        if (aliases == null || aliases.length == 0) {
            return null;
        }
        if (aliases.length == 1) {
            IndexAlias indexAlias = this.alias(aliases[0]);
            if (indexAlias == null) {
                throw new InvalidAliasNameException(this.index, aliases[0], "Unknown alias name was passed to alias Filter");
            }
            return indexAlias.parsedFilter();
        }
        XBooleanFilter combined = new XBooleanFilter();
        for (String alias : aliases) {
            IndexAlias indexAlias = this.alias(alias);
            if (indexAlias == null) {
                throw new InvalidAliasNameException(this.index, aliases[0], "Unknown alias name was passed to alias Filter");
            }
            if (indexAlias.parsedFilter() == null) {
                return null;
            }
            combined.add(new FilterClause(indexAlias.parsedFilter(), BooleanClause.Occur.SHOULD));
        }
        if (combined.clauses().size() == 0) {
            return null;
        }
        if (combined.clauses().size() == 1) {
            return combined.clauses().get(0).getFilter();
        }
        return combined;
    }

    private void add(IndexAlias indexAlias) {
        this.aliases.put(indexAlias.alias(), indexAlias);
    }

    public void remove(String alias) {
        this.aliases.remove(alias);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Filter parse(String alias, CompressedString filter) {
        if (filter == null) {
            return null;
        }
        try {
            byte[] filterSource = filter.uncompressed();
            try (XContentParser parser = XContentFactory.xContent(filterSource).createParser(filterSource);){
                ParsedFilter parsedFilter = this.indexQueryParser.parseInnerFilter(parser);
                Filter filter2 = parsedFilter == null ? null : parsedFilter.filter();
                return filter2;
            }
        }
        catch (IOException ex) {
            throw new AliasFilterParsingException(this.index, alias, "Invalid alias filter", (Throwable)ex);
        }
    }

    @Override
    public Iterator<IndexAlias> iterator() {
        return this.aliases.values().iterator();
    }
}

