/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.filter.ShardFilterCacheModule;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilterCache;
import org.elasticsearch.index.cache.query.ShardQueryCacheModule;
import org.elasticsearch.index.deletionpolicy.DeletionPolicyModule;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ShardFieldDataModule;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayModule;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.get.ShardGetModule;
import org.elasticsearch.index.indexing.ShardIndexingModule;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.merge.policy.MergePolicyModule;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerModule;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;
import org.elasticsearch.index.percolator.PercolatorShardModule;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.search.stats.ShardSearchModule;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardCreationException;
import org.elasticsearch.index.shard.IndexShardModule;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotModule;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreModule;
import org.elasticsearch.index.suggest.SuggestShardModule;
import org.elasticsearch.index.termvectors.ShardTermVectorModule;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogModule;
import org.elasticsearch.index.translog.TranslogService;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ShardsPluginsModule;

public class IndexService
extends AbstractIndexComponent
implements IndexComponent,
Iterable<IndexShard> {
    private final Injector injector;
    private final Settings indexSettings;
    private final PluginsService pluginsService;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final AnalysisService analysisService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final SimilarityService similarityService;
    private final IndexAliasesService aliasesService;
    private final IndexCache indexCache;
    private final IndexFieldDataService indexFieldData;
    private final FixedBitSetFilterCache fixedBitSetFilterCache;
    private final IndexEngine indexEngine;
    private final IndexGateway indexGateway;
    private final IndexStore indexStore;
    private final IndexSettingsService settingsService;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesServices;
    private volatile ImmutableMap<Integer, Tuple<IndexShard, Injector>> shards = ImmutableMap.of();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);

    @Inject
    public IndexService(Injector injector, Index index, @IndexSettings Settings indexSettings, NodeEnvironment nodeEnv, AnalysisService analysisService, MapperService mapperService, IndexQueryParserService queryParserService, SimilarityService similarityService, IndexAliasesService aliasesService, IndexCache indexCache, IndexEngine indexEngine, IndexGateway indexGateway, IndexStore indexStore, IndexSettingsService settingsService, IndexFieldDataService indexFieldData, FixedBitSetFilterCache fixedBitSetFilterCache, IndicesService indicesServices) {
        super(index, indexSettings);
        this.injector = injector;
        this.indexSettings = indexSettings;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.similarityService = similarityService;
        this.aliasesService = aliasesService;
        this.indexCache = indexCache;
        this.indexFieldData = indexFieldData;
        this.indexEngine = indexEngine;
        this.indexGateway = indexGateway;
        this.indexStore = indexStore;
        this.settingsService = settingsService;
        this.fixedBitSetFilterCache = fixedBitSetFilterCache;
        this.pluginsService = injector.getInstance(PluginsService.class);
        this.indicesServices = indicesServices;
        this.indicesLifecycle = (InternalIndicesLifecycle)injector.getInstance(IndicesLifecycle.class);
        indexCache.filter().setIndexService(this);
        indexFieldData.setIndexService(this);
        fixedBitSetFilterCache.setIndexService(this);
        this.nodeEnv = nodeEnv;
    }

    public int numberOfShards() {
        return this.shards.size();
    }

    public InternalIndicesLifecycle indicesLifecycle() {
        return this.indicesLifecycle;
    }

    @Override
    public Iterator<IndexShard> iterator() {
        return Iterators.transform(((ImmutableCollection)this.shards.values()).iterator(), new Function<Tuple<IndexShard, Injector>, IndexShard>(){

            @Override
            public IndexShard apply(Tuple<IndexShard, Injector> input) {
                return input.v1();
            }
        });
    }

    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    @Nullable
    public IndexShard shard(int shardId) {
        Tuple<IndexShard, Injector> indexShardInjectorTuple = this.shards.get(shardId);
        if (indexShardInjectorTuple != null) {
            return indexShardInjectorTuple.v1();
        }
        return null;
    }

    public IndexShard shardSafe(int shardId) throws IndexShardMissingException {
        IndexShard indexShard = this.shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(this.index, shardId));
        }
        return indexShard;
    }

    public Set<Integer> shardIds() {
        return this.shards.keySet();
    }

    public Injector injector() {
        return this.injector;
    }

    public IndexGateway gateway() {
        return this.indexGateway;
    }

    public IndexSettingsService settingsService() {
        return this.settingsService;
    }

    public IndexStore store() {
        return this.indexStore;
    }

    public IndexCache cache() {
        return this.indexCache;
    }

    public IndexFieldDataService fieldData() {
        return this.indexFieldData;
    }

    public FixedBitSetFilterCache fixedBitSetFilterCache() {
        return this.fixedBitSetFilterCache;
    }

    public AnalysisService analysisService() {
        return this.analysisService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexQueryParserService queryParserService() {
        return this.queryParserService;
    }

    public SimilarityService similarityService() {
        return this.similarityService;
    }

    public IndexAliasesService aliasesService() {
        return this.aliasesService;
    }

    public synchronized void close(String reason, boolean delete) {
        if (this.closed.compareAndSet(false, true)) {
            this.deleted.compareAndSet(false, delete);
            Set<Integer> shardIds = this.shardIds();
            for (int shardId : shardIds) {
                try {
                    this.removeShard(shardId, reason);
                }
                catch (Throwable t) {
                    this.logger.warn("failed to close shard", t, new Object[0]);
                }
            }
        }
    }

    public Injector shardInjectorSafe(int shardId) throws IndexShardMissingException {
        Tuple<IndexShard, Injector> tuple = this.shards.get(shardId);
        if (tuple == null) {
            throw new IndexShardMissingException(new ShardId(this.index, shardId));
        }
        return tuple.v2();
    }

    public String indexUUID() {
        return this.indexSettings.get("index.uuid", "_na_");
    }

    public synchronized IndexShard createShard(int sShardId, boolean primary) throws ElasticsearchException {
        IndexShard indexShard;
        block12: {
            if (this.closed.get()) {
                throw new ElasticsearchIllegalStateException("Can't create shard [" + this.index.name() + "][" + sShardId + "], closed");
            }
            ShardId shardId = new ShardId(this.index, sShardId);
            ShardLock lock = null;
            boolean success = false;
            Injector shardInjector = null;
            try {
                lock = this.nodeEnv.shardLock(shardId, TimeUnit.SECONDS.toMillis(5L));
                if (this.shards.containsKey(shardId.id())) {
                    throw new IndexShardAlreadyExistsException(shardId + " already exists");
                }
                this.indicesLifecycle.beforeIndexShardCreated(shardId, this.indexSettings);
                this.logger.debug("creating shard_id {}", shardId);
                boolean canDeleteShardContent = !IndexMetaData.isOnSharedFilesystem(this.indexSettings) || primary && IndexMetaData.isOnSharedFilesystem(this.indexSettings);
                ModulesBuilder modules = new ModulesBuilder();
                modules.add((Module)new ShardsPluginsModule(this.indexSettings, this.pluginsService));
                modules.add((Module)new IndexShardModule(shardId, primary, this.indexSettings));
                modules.add((Module)new ShardIndexingModule());
                modules.add((Module)new ShardSearchModule());
                modules.add((Module)new ShardGetModule());
                modules.add((Module)new StoreModule(this.indexSettings, this.injector.getInstance(IndexStore.class), lock, new StoreCloseListener(shardId, canDeleteShardContent)));
                modules.add((Module)new DeletionPolicyModule(this.indexSettings));
                modules.add((Module)new MergePolicyModule(this.indexSettings));
                modules.add((Module)new MergeSchedulerModule(this.indexSettings));
                modules.add((Module)new ShardFilterCacheModule());
                modules.add((Module)new ShardQueryCacheModule());
                modules.add((Module)new ShardFieldDataModule());
                modules.add((Module)new TranslogModule(this.indexSettings));
                modules.add((Module)new IndexShardGatewayModule(this.injector.getInstance(IndexGateway.class)));
                modules.add((Module)new PercolatorShardModule());
                modules.add((Module)new ShardTermVectorModule());
                modules.add((Module)new IndexShardSnapshotModule());
                modules.add((Module)new SuggestShardModule());
                try {
                    shardInjector = modules.createChildInjector(this.injector);
                }
                catch (CreationException e) {
                    throw new IndexShardCreationException(shardId, Injectors.getFirstErrorFailure(e));
                }
                catch (Throwable e) {
                    throw new IndexShardCreationException(shardId, e);
                }
                IndexShard indexShard2 = shardInjector.getInstance(IndexShard.class);
                this.indicesLifecycle.indexShardStateChanged(indexShard2, null, "shard created");
                this.indicesLifecycle.afterIndexShardCreated(indexShard2);
                this.shards = MapBuilder.newMapBuilder(this.shards).put(shardId.id(), new Tuple<IndexShard, Injector>(indexShard2, shardInjector)).immutableMap();
                success = true;
                indexShard = indexShard2;
                if (success) break block12;
            }
            catch (IOException ex) {
                try {
                    throw new IndexShardCreationException(shardId, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(lock);
                        if (shardInjector != null) {
                            IndexShard indexShard3 = shardInjector.getInstance(IndexShard.class);
                            this.closeShardInjector("initialization failed", shardId, shardInjector, indexShard3);
                        }
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(lock);
            if (shardInjector != null) {
                IndexShard indexShard4 = shardInjector.getInstance(IndexShard.class);
                this.closeShardInjector("initialization failed", shardId, shardInjector, indexShard4);
            }
        }
        return indexShard;
    }

    public synchronized void removeShard(int shardId, String reason) throws ElasticsearchException {
        ShardId sId = new ShardId(this.index, shardId);
        if (!this.shards.containsKey(shardId)) {
            return;
        }
        this.logger.debug("[{}] closing... (reason: [{}])", shardId, reason);
        HashMap<Integer, Tuple<IndexShard, Injector>> tmpShardsMap = Maps.newHashMap(this.shards);
        Tuple<IndexShard, Injector> tuple = tmpShardsMap.remove(shardId);
        IndexShard indexShard = tuple.v1();
        Injector shardInjector = tuple.v2();
        this.shards = ImmutableMap.copyOf(tmpShardsMap);
        this.closeShardInjector(reason, sId, shardInjector, indexShard);
        this.logger.debug("[{}] closed (reason: [{}])", shardId, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeShardInjector(String reason, ShardId sId, Injector shardInjector, IndexShard indexShard) {
        int shardId = sId.id();
        try {
            try {
                this.indicesLifecycle.beforeIndexShardClosed(sId, indexShard, this.indexSettings);
            }
            catch (Throwable throwable) {
                for (Class<? extends CloseableIndexComponent> closeable : this.pluginsService.shardServices()) {
                    try {
                        shardInjector.getInstance(closeable).close();
                    }
                    catch (Throwable e) {
                        this.logger.debug("[{}] failed to clean plugin shard service [{}]", e, shardId, closeable);
                    }
                }
                this.closeInjectorResource(sId, shardInjector, TranslogService.class);
                if (indexShard != null) {
                    try {
                        boolean flushEngine = !this.deleted.get() && this.closed.get();
                        indexShard.close(reason, flushEngine);
                    }
                    catch (Throwable e) {
                        this.logger.debug("[{}] failed to close index shard", e, shardId);
                    }
                }
                this.closeInjectorResource(sId, shardInjector, MergeSchedulerProvider.class, MergePolicyProvider.class, IndexShardGatewayService.class, Translog.class, PercolatorQueriesRegistry.class);
                this.indicesLifecycle.afterIndexShardClosed(sId, indexShard, this.indexSettings);
                throw throwable;
            }
            for (Class<? extends CloseableIndexComponent> closeable : this.pluginsService.shardServices()) {
                try {
                    shardInjector.getInstance(closeable).close();
                }
                catch (Throwable e) {
                    this.logger.debug("[{}] failed to clean plugin shard service [{}]", e, shardId, closeable);
                }
            }
            this.closeInjectorResource(sId, shardInjector, TranslogService.class);
            if (indexShard != null) {
                try {
                    boolean flushEngine = !this.deleted.get() && this.closed.get();
                    indexShard.close(reason, flushEngine);
                }
                catch (Throwable e) {
                    this.logger.debug("[{}] failed to close index shard", e, shardId);
                }
            }
            this.closeInjectorResource(sId, shardInjector, MergeSchedulerProvider.class, MergePolicyProvider.class, IndexShardGatewayService.class, Translog.class, PercolatorQueriesRegistry.class);
            this.indicesLifecycle.afterIndexShardClosed(sId, indexShard, this.indexSettings);
        }
        catch (Throwable throwable) {
            try {
                shardInjector.getInstance(Store.class).close();
            }
            catch (Throwable e) {
                this.logger.warn("[{}] failed to close store on shard removal (reason: [{}])", e, shardId, reason);
            }
            throw throwable;
        }
        try {
            shardInjector.getInstance(Store.class).close();
        }
        catch (Throwable e) {
            this.logger.warn("[{}] failed to close store on shard removal (reason: [{}])", e, shardId, reason);
        }
    }

    private void closeInjectorResource(ShardId shardId, Injector shardInjector, Class<? extends Closeable> ... toClose) {
        for (Class<? extends Closeable> closeable : toClose) {
            try {
                Closeable instance = shardInjector.getInstance(closeable);
                if (instance == null) {
                    throw new NullPointerException("No instance available for " + closeable.getName());
                }
                IOUtils.close(instance);
            }
            catch (Throwable t) {
                this.logger.debug("{} failed to close {}", t, shardId, Strings.toUnderscoreCase(closeable.getSimpleName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onShardClose(ShardLock lock, boolean ownsShard) {
        block6: {
            if (this.deleted.get()) {
                try {
                    if (!ownsShard) break block6;
                    try {
                        this.indicesLifecycle.beforeIndexShardDeleted(lock.getShardId(), this.indexSettings);
                    }
                    finally {
                        this.indicesServices.deleteShardStore("delete index", lock, this.indexSettings);
                        this.indicesLifecycle.afterIndexShardDeleted(lock.getShardId(), this.indexSettings);
                    }
                }
                catch (IOException e) {
                    this.indicesServices.addPendingDelete(lock.getShardId(), this.indexSettings);
                    this.logger.debug("[{}] failed to delete shard content - scheduled a retry", e, lock.getShardId().id());
                }
            }
        }
    }

    public Settings getIndexSettings() {
        return this.indexSettings;
    }

    private class StoreCloseListener
    implements Store.OnClose {
        private final ShardId shardId;
        private final boolean ownsShard;

        public StoreCloseListener(ShardId shardId, boolean ownsShard) {
            this.shardId = shardId;
            this.ownsShard = ownsShard;
        }

        @Override
        public void handle(ShardLock lock) {
            assert (lock.getShardId().equals(this.shardId)) : "shard Id mismatch, expected: " + this.shardId + " but got: " + lock.getShardId();
            IndexService.this.onShardClose(lock, this.ownsShard);
        }
    }
}

