/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.meta;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.XIOUtils;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public abstract class MetaDataStateFormat<T> {
    public static final String STATE_DIR_NAME = "_state";
    public static final String STATE_FILE_EXTENSION = ".st";
    private static final String STATE_FILE_CODEC = "state";
    private static final int STATE_FILE_VERSION = 0;
    private static final int BUFFER_SIZE = 4096;
    private final XContentType format;
    private final String prefix;
    private final Pattern stateFilePattern;

    protected MetaDataStateFormat(XContentType format, String prefix) {
        this.format = format;
        this.prefix = prefix;
        this.stateFilePattern = Pattern.compile(Pattern.quote(prefix) + "(\\d+)(" + STATE_FILE_EXTENSION + ")?");
    }

    public XContentType format() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(T state, long version, File ... locations) throws IOException {
        Preconditions.checkArgument(locations != null, "Locations must not be null");
        Preconditions.checkArgument(locations.length > 0, "One or more locations required");
        long maxStateId = this.findMaxStateId(this.prefix, locations) + 1L;
        assert (maxStateId >= 0L) : "maxStateId must be positive but was: [" + maxStateId + "]";
        String fileName = this.prefix + maxStateId + STATE_FILE_EXTENSION;
        Path stateLocation = Paths.get(locations[0].getPath(), STATE_DIR_NAME);
        Files.createDirectories(stateLocation, new FileAttribute[0]);
        Path tmpStatePath = stateLocation.resolve(fileName + ".tmp");
        Path finalStatePath = stateLocation.resolve(fileName);
        try {
            try (OutputStreamIndexOutput out = new OutputStreamIndexOutput(Files.newOutputStream(tmpStatePath, new OpenOption[0]), 4096);){
                CodecUtil.writeHeader(out, STATE_FILE_CODEC, 0);
                out.writeInt(this.format.index());
                out.writeLong(version);
                try (XContentBuilder builder = this.newXContentBuilder(this.format, new org.elasticsearch.common.lucene.store.OutputStreamIndexOutput(out){

                    @Override
                    public void close() throws IOException {
                    }
                });){
                    builder.startObject();
                    this.toXContent(builder, state);
                    builder.endObject();
                }
                CodecUtil.writeFooter(out);
            }
            IOUtils.fsync(tmpStatePath.toFile(), false);
            Files.move(tmpStatePath, finalStatePath, StandardCopyOption.ATOMIC_MOVE);
            IOUtils.fsync(stateLocation.toFile(), true);
            for (int i = 1; i < locations.length; ++i) {
                stateLocation = Paths.get(locations[i].getPath(), STATE_DIR_NAME);
                Files.createDirectories(stateLocation, new FileAttribute[0]);
                Path tmpPath = stateLocation.resolve(fileName + ".tmp");
                Path finalPath = stateLocation.resolve(fileName);
                try {
                    Files.copy(finalStatePath, tmpPath, new CopyOption[0]);
                    Files.move(tmpPath, finalPath, StandardCopyOption.ATOMIC_MOVE);
                    IOUtils.fsync(stateLocation.toFile(), true);
                    continue;
                }
                finally {
                    Files.deleteIfExists(tmpPath);
                }
            }
        }
        finally {
            Files.deleteIfExists(tmpStatePath);
        }
        this.cleanupOldFiles(this.prefix, fileName, locations);
    }

    protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
        return XContentFactory.contentBuilder(type, stream);
    }

    public abstract void toXContent(XContentBuilder var1, T var2) throws IOException;

    public abstract T fromXContent(XContentParser var1) throws IOException;

    /*
     * Exception decompiling
     */
    public final T read(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Directory newDirectory(File dir) throws IOException {
        return new SimpleFSDirectory(dir);
    }

    private void cleanupOldFiles(String prefix, String fileName, File[] locations) throws IOException {
        for (File dataLocation : locations) {
            File[] files = new File(dataLocation, STATE_DIR_NAME).listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.getName().startsWith(prefix) || file.getName().equals(fileName)) continue;
                Files.delete(file.toPath());
            }
        }
    }

    long findMaxStateId(String prefix, File ... locations) throws IOException {
        long maxId = -1L;
        for (File dataLocation : locations) {
            File[] files = new File(dataLocation, STATE_DIR_NAME).listFiles();
            if (files == null) continue;
            for (File file : files) {
                Matcher matcher;
                if (!file.getName().startsWith(prefix) || !(matcher = this.stateFilePattern.matcher(file.getName())).matches()) continue;
                long id = Long.parseLong(matcher.group(1));
                maxId = Math.max(maxId, id);
            }
        }
        return maxId;
    }

    public T loadLatestState(ESLogger logger, File ... dataLocations) {
        ArrayList<FileAndStateId> files = new ArrayList<FileAndStateId>();
        long maxStateId = -1L;
        boolean maxStateIdIsLegacy = true;
        if (dataLocations != null) {
            for (File dataLocation : dataLocations) {
                File stateDir = new File(dataLocation, STATE_DIR_NAME);
                File[] stateFiles = stateDir.listFiles();
                if (stateFiles == null) continue;
                for (File stateFile : stateFiles) {
                    Matcher matcher = this.stateFilePattern.matcher(stateFile.getName());
                    if (!matcher.matches()) continue;
                    long version = Long.parseLong(matcher.group(1));
                    maxStateId = Math.max(maxStateId, version);
                    boolean legacy = !STATE_FILE_EXTENSION.equals(matcher.group(2));
                    maxStateIdIsLegacy &= legacy;
                    files.add(new FileAndStateId(stateFile, version, legacy));
                }
            }
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        T state = null;
        for (FileAndStateId fileAndVersion : Collections2.filter(files, new StateIdAndLegacyPredicate(maxStateId, maxStateIdIsLegacy))) {
            try {
                block23: {
                    File stateFile = fileAndVersion.file;
                    long id = fileAndVersion.id;
                    if (fileAndVersion.legacy) {
                        FileInputStream stream = new FileInputStream(stateFile);
                        Throwable throwable = null;
                        try {
                            byte[] data = Streams.copyToByteArray(stream);
                            if (data.length == 0) {
                                logger.debug("{}: no data for [{}], ignoring...", this.prefix, stateFile.getAbsolutePath());
                                continue;
                            }
                            XContentParser parser = XContentHelper.createParser(data, 0, data.length);
                            state = this.fromXContent(parser);
                            if (state == null) {
                                logger.debug("{}: no data for [{}], ignoring...", this.prefix, stateFile.getAbsolutePath());
                            }
                            break block23;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            stream.close();
                            continue;
                        }
                    }
                    state = this.read(stateFile);
                    logger.trace("state id [{}] read from [{}]", id, stateFile.getName());
                }
                return state;
            }
            catch (Throwable e) {
                exceptions.add(e);
                logger.debug("{}: failed to read [{}], ignoring...", e, fileAndVersion.file.getAbsolutePath(), this.prefix);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        if (files.size() > 0) {
            throw new ElasticsearchIllegalStateException("Could not find a state file to recover from among " + files);
        }
        return state;
    }

    public static void deleteMetaState(Path ... dataLocations) throws IOException {
        Path[] stateDirectories = new Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            stateDirectories[i] = dataLocations[i].resolve(STATE_DIR_NAME);
        }
        XIOUtils.rm(stateDirectories);
    }

    private static class FileAndStateId {
        final File file;
        final long id;
        final boolean legacy;

        private FileAndStateId(File file, long id, boolean legacy) {
            this.file = file;
            this.id = id;
            this.legacy = legacy;
        }

        public String toString() {
            return "[id:" + this.id + ", legacy:" + this.legacy + ", file:" + this.file.getAbsolutePath() + "]";
        }
    }

    private static final class StateIdAndLegacyPredicate
    implements Predicate<FileAndStateId> {
        private final long id;
        private final boolean legacy;

        StateIdAndLegacyPredicate(long id, boolean legacy) {
            this.id = id;
            this.legacy = legacy;
        }

        @Override
        public boolean apply(FileAndStateId input) {
            return input.id == this.id && input.legacy == this.legacy;
        }
    }
}

