/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.os.OsUtils;

public abstract class NetworkUtils {
    private static final ESLogger logger;
    public static final String IPv4_SETTING = "java.net.preferIPv4Stack";
    public static final String IPv6_SETTING = "java.net.preferIPv6Addresses";
    public static final String NON_LOOPBACK_ADDRESS = "non_loopback_address";
    private static final InetAddress localAddress;

    public static boolean defaultReuseAddress() {
        return !OsUtils.WINDOWS;
    }

    public static boolean isIPv4() {
        return System.getProperty(IPv4_SETTING) != null && System.getProperty(IPv4_SETTING).equals("true");
    }

    public static InetAddress getIPv4Localhost() throws UnknownHostException {
        return NetworkUtils.getLocalhost(StackType.IPv4);
    }

    public static InetAddress getIPv6Localhost() throws UnknownHostException {
        return NetworkUtils.getLocalhost(StackType.IPv6);
    }

    public static InetAddress getLocalAddress() {
        return localAddress;
    }

    public static String getLocalHostName(String defaultHostName) {
        if (localAddress == null) {
            return defaultHostName;
        }
        String hostName = localAddress.getHostName();
        if (hostName == null) {
            return defaultHostName;
        }
        return hostName;
    }

    public static String getLocalHostAddress(String defaultHostAddress) {
        if (localAddress == null) {
            return defaultHostAddress;
        }
        String hostAddress = localAddress.getHostAddress();
        if (hostAddress == null) {
            return defaultHostAddress;
        }
        return hostAddress;
    }

    public static InetAddress getLocalhost(StackType ip_version) throws UnknownHostException {
        if (ip_version == StackType.IPv4) {
            return InetAddress.getByName("127.0.0.1");
        }
        return InetAddress.getByName("::1");
    }

    public static boolean canBindToMcastAddress() {
        return OsUtils.LINUX || OsUtils.SOLARIS || OsUtils.HP;
    }

    public static InetAddress getFirstNonLoopbackAddress(StackType ip_version) throws SocketException {
        for (NetworkInterface intf : NetworkUtils.getInterfaces()) {
            try {
                if (!intf.isUp()) continue;
                if (intf.isLoopback()) {
                }
            }
            catch (Exception e) {}
            continue;
            InetAddress address = NetworkUtils.getFirstNonLoopbackAddress(intf, ip_version);
            if (address == null) continue;
            return address;
        }
        return null;
    }

    private static List<NetworkInterface> getInterfaces() throws SocketException {
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        ArrayList<NetworkInterface> intfsList = Lists.newArrayList();
        while (intfs.hasMoreElements()) {
            intfsList.add(intfs.nextElement());
        }
        NetworkUtils.sortInterfaces(intfsList);
        return intfsList;
    }

    private static void sortInterfaces(List<NetworkInterface> intfsList) {
        CollectionUtil.timSort(intfsList, new Comparator<NetworkInterface>(){

            @Override
            public int compare(NetworkInterface o1, NetworkInterface o2) {
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
    }

    public static InetAddress getFirstNonLoopbackAddress(NetworkInterface intf, StackType ipVersion) throws SocketException {
        if (intf == null) {
            throw new IllegalArgumentException("Network interface pointer is null");
        }
        Enumeration<InetAddress> addresses = intf.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (address.isLoopbackAddress() || (!(address instanceof Inet4Address) || ipVersion != StackType.IPv4) && (!(address instanceof Inet6Address) || ipVersion != StackType.IPv6)) continue;
            return address;
        }
        return null;
    }

    public static InetAddress getFirstAddress(NetworkInterface intf, StackType ipVersion) throws SocketException {
        if (intf == null) {
            throw new IllegalArgumentException("Network interface pointer is null");
        }
        Enumeration<InetAddress> addresses = intf.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if ((!(address instanceof Inet4Address) || ipVersion != StackType.IPv4) && (!(address instanceof Inet6Address) || ipVersion != StackType.IPv6)) continue;
            return address;
        }
        return null;
    }

    public static boolean interfaceHasIPAddresses(NetworkInterface intf, StackType ipVersion) throws SocketException, UnknownHostException {
        boolean supportsVersion = false;
        if (intf != null) {
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if ((!(address instanceof Inet4Address) || ipVersion != StackType.IPv4) && (!(address instanceof Inet6Address) || ipVersion != StackType.IPv6)) continue;
                supportsVersion = true;
                break;
            }
        } else {
            throw new UnknownHostException("network interface not found");
        }
        return supportsVersion;
    }

    public static StackType getIpStackType() {
        boolean isIPv4StackAvailable = NetworkUtils.isStackAvailable(true);
        boolean isIPv6StackAvailable = NetworkUtils.isStackAvailable(false);
        if (isIPv4StackAvailable && !isIPv6StackAvailable) {
            return StackType.IPv4;
        }
        if (isIPv6StackAvailable && !isIPv4StackAvailable) {
            return StackType.IPv6;
        }
        if (isIPv4StackAvailable && isIPv6StackAvailable) {
            if (Boolean.getBoolean(IPv4_SETTING)) {
                return StackType.IPv4;
            }
            if (Boolean.getBoolean(IPv6_SETTING)) {
                return StackType.IPv6;
            }
            return StackType.IPv6;
        }
        return StackType.Unknown;
    }

    public static boolean isStackAvailable(boolean ipv4) {
        Collection<InetAddress> allAddrs = NetworkUtils.getAllAvailableAddresses();
        for (InetAddress addr : allAddrs) {
            if ((!ipv4 || !(addr instanceof Inet4Address)) && (ipv4 || !(addr instanceof Inet6Address))) continue;
            return true;
        }
        return false;
    }

    public static List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> allInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface intf = interfaces.nextElement();
            allInterfaces.add(intf);
            Enumeration<NetworkInterface> subInterfaces = intf.getSubInterfaces();
            if (subInterfaces == null || !subInterfaces.hasMoreElements()) continue;
            while (subInterfaces.hasMoreElements()) {
                allInterfaces.add(subInterfaces.nextElement());
            }
        }
        NetworkUtils.sortInterfaces(allInterfaces);
        return allInterfaces;
    }

    public static Collection<InetAddress> getAllAvailableAddresses() {
        TreeSet<InetAddress> retval = new TreeSet<InetAddress>(new Comparator<InetAddress>(){
            BytesRef left = new BytesRef();
            BytesRef right = new BytesRef();

            @Override
            public int compare(InetAddress o1, InetAddress o2) {
                return this.set(this.left, o1).compareTo(this.set(this.right, o1));
            }

            private BytesRef set(BytesRef ref, InetAddress addr) {
                ref.bytes = addr.getAddress();
                ref.offset = 0;
                ref.length = ref.bytes.length;
                return ref;
            }
        });
        try {
            for (NetworkInterface intf : NetworkUtils.getInterfaces()) {
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    retval.add(addrs.nextElement());
                }
            }
        }
        catch (SocketException e) {
            logger.warn("Failed to derive all available interfaces", e, new Object[0]);
        }
        return retval;
    }

    private NetworkUtils() {
    }

    static {
        InetAddress localAddressX;
        logger = Loggers.getLogger(NetworkUtils.class);
        try {
            localAddressX = InetAddress.getLocalHost();
        }
        catch (Throwable e) {
            logger.warn("failed to resolve local host, fallback to loopback", e, new Object[0]);
            localAddressX = InetAddress.getLoopbackAddress();
        }
        localAddress = localAddressX;
    }

    public static enum StackType {
        IPv4,
        IPv6,
        Unknown;

    }
}

