/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.lucene.uid.Versions;

final class PerThreadIDAndVersionLookup {
    private final AtomicReaderContext[] readerContexts;
    private final TermsEnum[] termsEnums;
    private final DocsEnum[] docsEnums;
    private final DocsAndPositionsEnum[] posEnums;
    private final Bits[] liveDocs;
    private final NumericDocValues[] versions;
    private final int numSegs;
    private final boolean hasDeletions;
    private final boolean[] hasPayloads;

    public PerThreadIDAndVersionLookup(IndexReader r) throws IOException {
        ArrayList<AtomicReaderContext> leaves = new ArrayList<AtomicReaderContext>(r.leaves());
        this.readerContexts = leaves.toArray(new AtomicReaderContext[leaves.size()]);
        this.termsEnums = new TermsEnum[leaves.size()];
        this.docsEnums = new DocsEnum[leaves.size()];
        this.posEnums = new DocsAndPositionsEnum[leaves.size()];
        this.liveDocs = new Bits[leaves.size()];
        this.versions = new NumericDocValues[leaves.size()];
        this.hasPayloads = new boolean[leaves.size()];
        int numSegs = 0;
        boolean hasDeletions = false;
        for (int i = leaves.size() - 1; i >= 0; --i) {
            Terms terms;
            AtomicReaderContext readerContext = (AtomicReaderContext)leaves.get(i);
            Fields fields = readerContext.reader().fields();
            if (fields == null || (terms = fields.terms("_uid")) == null) continue;
            this.readerContexts[numSegs] = readerContext;
            this.hasPayloads[numSegs] = terms.hasPayloads();
            this.termsEnums[numSegs] = terms.iterator(null);
            assert (this.termsEnums[numSegs] != null);
            this.liveDocs[numSegs] = readerContext.reader().getLiveDocs();
            hasDeletions |= readerContext.reader().hasDeletions();
            this.versions[numSegs] = readerContext.reader().getNumericDocValues("_version");
            ++numSegs;
        }
        this.numSegs = numSegs;
        this.hasDeletions = hasDeletions;
    }

    public Versions.DocIdAndVersion lookup(BytesRef id) throws IOException {
        for (int seg = 0; seg < this.numSegs; ++seg) {
            int d;
            int docID;
            if (!this.termsEnums[seg].seekExact(id)) continue;
            NumericDocValues segVersions = this.versions[seg];
            if (segVersions != null || !this.hasPayloads[seg]) {
                DocsEnum docs = this.docsEnums[seg] = this.termsEnums[seg].docs(this.liveDocs[seg], this.docsEnums[seg], 0);
                docID = Integer.MAX_VALUE;
                d = docs.nextDoc();
                while (d != Integer.MAX_VALUE) {
                    docID = d;
                    d = docs.nextDoc();
                }
                if (docID != Integer.MAX_VALUE) {
                    if (segVersions != null) {
                        return new Versions.DocIdAndVersion(docID, segVersions.get(docID), this.readerContexts[seg]);
                    }
                    return new Versions.DocIdAndVersion(docID, -2L, this.readerContexts[seg]);
                }
                assert (this.hasDeletions);
                continue;
            }
            DocsAndPositionsEnum dpe = this.posEnums[seg] = this.termsEnums[seg].docsAndPositions(this.liveDocs[seg], this.posEnums[seg], 2);
            assert (dpe != null);
            docID = Integer.MAX_VALUE;
            d = dpe.nextDoc();
            while (d != Integer.MAX_VALUE) {
                docID = d;
                dpe.nextPosition();
                BytesRef payload = dpe.getPayload();
                if (payload != null && payload.length == 8) {
                    return new Versions.DocIdAndVersion(d, Numbers.bytesToLong(payload), this.readerContexts[seg]);
                }
                d = dpe.nextDoc();
            }
        }
        return null;
    }
}

