/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ComplexExplanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.CustomBoostFactorScorer;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.lucene.search.function.WeightFactorFunction;

public class FiltersFunctionScoreQuery
extends Query {
    Query subQuery;
    final FilterFunction[] filterFunctions;
    final ScoreMode scoreMode;
    final float maxBoost;
    private Float minScore;
    protected CombineFunction combineFunction;

    public FiltersFunctionScoreQuery(Query subQuery, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost, Float minScore) {
        this.subQuery = subQuery;
        this.scoreMode = scoreMode;
        this.filterFunctions = filterFunctions;
        this.maxBoost = maxBoost;
        this.combineFunction = CombineFunction.MULT;
        this.minScore = minScore;
    }

    public FiltersFunctionScoreQuery setCombineFunction(CombineFunction combineFunction) {
        this.combineFunction = combineFunction;
        return this;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public FilterFunction[] getFilterFunctions() {
        return this.filterFunctions;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FiltersFunctionScoreQuery bq = (FiltersFunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Weight subQueryWeight = this.subQuery.createWeight(searcher);
        return new CustomBoostFactorWeight(subQueryWeight, this.filterFunctions.length);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(", functions: [");
        for (FilterFunction filterFunction : this.filterFunctions) {
            sb.append("{filter(").append(filterFunction.filter).append("), function [").append(filterFunction.function).append("]}");
        }
        sb.append("])");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiltersFunctionScoreQuery other = (FiltersFunctionScoreQuery)o;
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (!this.subQuery.equals(other.subQuery)) {
            return false;
        }
        return Arrays.equals(this.filterFunctions, other.filterFunctions);
    }

    @Override
    public int hashCode() {
        return this.subQuery.hashCode() + 31 * Arrays.hashCode(this.filterFunctions) ^ Float.floatToIntBits(this.getBoost());
    }

    static class FiltersFunctionFactorScorer
    extends CustomBoostFactorScorer {
        private final FilterFunction[] filterFunctions;
        private final ScoreMode scoreMode;
        private final Bits[] docSets;

        private FiltersFunctionFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost, Bits[] docSets, CombineFunction scoreCombiner, Float minScore) throws IOException {
            super(w, scorer, maxBoost, scoreCombiner, minScore);
            this.scoreMode = scoreMode;
            this.filterFunctions = filterFunctions;
            this.docSets = docSets;
        }

        @Override
        public float innerScore() throws IOException {
            int docId = this.scorer.docID();
            double factor = 1.0;
            float subQueryScore = this.scorer.score();
            if (this.scoreMode == ScoreMode.First) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    factor = this.filterFunctions[i].function.score(docId, subQueryScore);
                    break;
                }
            } else if (this.scoreMode == ScoreMode.Max) {
                double maxFactor = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    maxFactor = Math.max(this.filterFunctions[i].function.score(docId, subQueryScore), maxFactor);
                }
                if (maxFactor != Double.NEGATIVE_INFINITY) {
                    factor = maxFactor;
                }
            } else if (this.scoreMode == ScoreMode.Min) {
                double minFactor = Double.POSITIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    minFactor = Math.min(this.filterFunctions[i].function.score(docId, subQueryScore), minFactor);
                }
                if (minFactor != Double.POSITIVE_INFINITY) {
                    factor = minFactor;
                }
            } else if (this.scoreMode == ScoreMode.Multiply) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    factor *= this.filterFunctions[i].function.score(docId, subQueryScore);
                }
            } else {
                double totalFactor = 0.0;
                float weightSum = 0.0f;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    totalFactor += this.filterFunctions[i].function.score(docId, subQueryScore);
                    if (this.filterFunctions[i].function instanceof WeightFactorFunction) {
                        weightSum += ((WeightFactorFunction)this.filterFunctions[i].function).getWeight();
                        continue;
                    }
                    weightSum += 1.0f;
                }
                if (weightSum != 0.0f) {
                    factor = totalFactor;
                    if (this.scoreMode == ScoreMode.Avg) {
                        factor /= (double)weightSum;
                    }
                }
            }
            return this.scoreCombiner.combine(this.subQueryBoost, subQueryScore, factor, this.maxBoost);
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;
        final Bits[] docSets;

        public CustomBoostFactorWeight(Weight subQueryWeight, int filterFunctionLength) throws IOException {
            this.subQueryWeight = subQueryWeight;
            this.docSets = new Bits[filterFunctionLength];
        }

        @Override
        public Query getQuery() {
            return FiltersFunctionScoreQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float sum = this.subQueryWeight.getValueForNormalization();
            return sum *= FiltersFunctionScoreQuery.this.getBoost() * FiltersFunctionScoreQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.subQueryWeight.normalize(norm, topLevelBoost * FiltersFunctionScoreQuery.this.getBoost());
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context, acceptDocs);
            if (subQueryScorer == null) {
                return null;
            }
            for (int i = 0; i < FiltersFunctionScoreQuery.this.filterFunctions.length; ++i) {
                FilterFunction filterFunction = FiltersFunctionScoreQuery.this.filterFunctions[i];
                filterFunction.function.setNextReader(context);
                this.docSets[i] = DocIdSets.toSafeBits(context.reader(), filterFunction.filter.getDocIdSet(context, acceptDocs));
            }
            return new FiltersFunctionFactorScorer(this, subQueryScorer, FiltersFunctionScoreQuery.this.scoreMode, FiltersFunctionScoreQuery.this.filterFunctions, FiltersFunctionScoreQuery.this.maxBoost, this.docSets, FiltersFunctionScoreQuery.this.combineFunction, FiltersFunctionScoreQuery.this.minScore);
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            ArrayList<ComplexExplanation> filterExplanations = new ArrayList<ComplexExplanation>();
            float weightSum = 0.0f;
            for (FilterFunction filterFunction : FiltersFunctionScoreQuery.this.filterFunctions) {
                weightSum = filterFunction.function instanceof WeightFactorFunction ? (weightSum += ((WeightFactorFunction)filterFunction.function).getWeight()) : (weightSum += 1.0f);
                Bits docSet = DocIdSets.toSafeBits(context.reader(), filterFunction.filter.getDocIdSet(context, context.reader().getLiveDocs()));
                if (!docSet.get(doc)) continue;
                filterFunction.function.setNextReader(context);
                Explanation functionExplanation = filterFunction.function.explainScore(doc, subQueryExpl);
                double factor = functionExplanation.getValue();
                float sc = CombineFunction.toFloat(factor);
                ComplexExplanation filterExplanation = new ComplexExplanation(true, sc, "function score, product of:");
                filterExplanation.addDetail(new Explanation(1.0f, "match filter: " + filterFunction.filter.toString()));
                filterExplanation.addDetail(functionExplanation);
                filterExplanations.add(filterExplanation);
            }
            if (filterExplanations.size() == 0) {
                float sc = FiltersFunctionScoreQuery.this.getBoost() * subQueryExpl.getValue();
                ComplexExplanation res = new ComplexExplanation(true, sc, "function score, no filter match, product of:");
                res.addDetail(subQueryExpl);
                res.addDetail(new Explanation(FiltersFunctionScoreQuery.this.getBoost(), "queryBoost"));
                return res;
            }
            double factor = 1.0;
            switch (FiltersFunctionScoreQuery.this.scoreMode) {
                case First: {
                    factor = ((ComplexExplanation)filterExplanations.get(0)).getValue();
                    break;
                }
                case Max: {
                    int i;
                    factor = Double.NEGATIVE_INFINITY;
                    for (i = 0; i < filterExplanations.size(); ++i) {
                        factor = Math.max((double)((ComplexExplanation)filterExplanations.get(i)).getValue(), factor);
                    }
                    break;
                }
                case Min: {
                    int i;
                    factor = Double.POSITIVE_INFINITY;
                    for (i = 0; i < filterExplanations.size(); ++i) {
                        factor = Math.min((double)((ComplexExplanation)filterExplanations.get(i)).getValue(), factor);
                    }
                    break;
                }
                case Multiply: {
                    int i;
                    for (i = 0; i < filterExplanations.size(); ++i) {
                        factor *= (double)((ComplexExplanation)filterExplanations.get(i)).getValue();
                    }
                    break;
                }
                default: {
                    double totalFactor = 0.0;
                    for (int i = 0; i < filterExplanations.size(); ++i) {
                        totalFactor += (double)((ComplexExplanation)filterExplanations.get(i)).getValue();
                    }
                    if (weightSum == 0.0f) break;
                    factor = totalFactor;
                    if (FiltersFunctionScoreQuery.this.scoreMode != ScoreMode.Avg) break;
                    factor /= (double)weightSum;
                }
            }
            ComplexExplanation factorExplanaition = new ComplexExplanation(true, CombineFunction.toFloat(factor), "function score, score mode [" + FiltersFunctionScoreQuery.this.scoreMode.toString().toLowerCase(Locale.ROOT) + "]");
            for (int i = 0; i < filterExplanations.size(); ++i) {
                factorExplanaition.addDetail((Explanation)filterExplanations.get(i));
            }
            return FiltersFunctionScoreQuery.this.combineFunction.explain(FiltersFunctionScoreQuery.this.getBoost(), subQueryExpl, factorExplanaition, FiltersFunctionScoreQuery.this.maxBoost);
        }
    }

    public static enum ScoreMode {
        First,
        Avg,
        Max,
        Sum,
        Min,
        Multiply;

    }

    public static class FilterFunction {
        public final Filter filter;
        public final ScoreFunction function;

        public FilterFunction(Filter filter, ScoreFunction function) {
            this.filter = filter;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterFunction that = (FilterFunction)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
        }

        public int hashCode() {
            int result = this.filter != null ? this.filter.hashCode() : 0;
            result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
            return result;
        }
    }
}

