/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ComplexExplanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;

public abstract class CombineFunction
extends Enum<CombineFunction> {
    public static final /* enum */ CombineFunction MULT = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 1.toFloat(queryBoost * queryScore * Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "multiply";
        }

        @Override
        public ComplexExplanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = queryBoost * Math.min(funcExpl.getValue(), maxBoost) * queryExpl.getValue();
            ComplexExplanation res = new ComplexExplanation(true, score, "function score, product of:");
            res.addDetail(queryExpl);
            ComplexExplanation minExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost), "Math.min of");
            minExpl.addDetail(funcExpl);
            minExpl.addDetail(new Explanation(maxBoost, "maxBoost"));
            res.addDetail(minExpl);
            res.addDetail(new Explanation(queryBoost, "queryBoost"));
            return res;
        }
    };
    public static final /* enum */ CombineFunction REPLACE = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 2.toFloat(queryBoost * Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public ComplexExplanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = queryBoost * Math.min(funcExpl.getValue(), maxBoost);
            ComplexExplanation res = new ComplexExplanation(true, score, "function score, product of:");
            ComplexExplanation minExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost), "Math.min of");
            minExpl.addDetail(funcExpl);
            minExpl.addDetail(new Explanation(maxBoost, "maxBoost"));
            res.addDetail(minExpl);
            res.addDetail(new Explanation(queryBoost, "queryBoost"));
            return res;
        }
    };
    public static final /* enum */ CombineFunction SUM = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 3.toFloat(queryBoost * (queryScore + Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "sum";
        }

        @Override
        public ComplexExplanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = queryBoost * (Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue());
            ComplexExplanation res = new ComplexExplanation(true, score, "function score, product of:");
            ComplexExplanation minExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost), "Math.min of");
            minExpl.addDetail(funcExpl);
            minExpl.addDetail(new Explanation(maxBoost, "maxBoost"));
            ComplexExplanation sumExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue(), "sum of");
            sumExpl.addDetail(queryExpl);
            sumExpl.addDetail(minExpl);
            res.addDetail(sumExpl);
            res.addDetail(new Explanation(queryBoost, "queryBoost"));
            return res;
        }
    };
    public static final /* enum */ CombineFunction AVG = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 4.toFloat(queryBoost * (Math.min(funcScore, maxBoost) + queryScore) / 2.0);
        }

        @Override
        public String getName() {
            return "avg";
        }

        @Override
        public ComplexExplanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = 4.toFloat((double)(queryBoost * (queryExpl.getValue() + Math.min(funcExpl.getValue(), maxBoost))) / 2.0);
            ComplexExplanation res = new ComplexExplanation(true, score, "function score, product of:");
            ComplexExplanation minExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost), "Math.min of");
            minExpl.addDetail(funcExpl);
            minExpl.addDetail(new Explanation(maxBoost, "maxBoost"));
            ComplexExplanation avgExpl = new ComplexExplanation(true, 4.toFloat((double)(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue()) / 2.0), "avg of");
            avgExpl.addDetail(queryExpl);
            avgExpl.addDetail(minExpl);
            res.addDetail(avgExpl);
            res.addDetail(new Explanation(queryBoost, "queryBoost"));
            return res;
        }
    };
    public static final /* enum */ CombineFunction MIN = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 5.toFloat(queryBoost * Math.min(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public ComplexExplanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = 5.toFloat(queryBoost * Math.min(queryExpl.getValue(), Math.min(funcExpl.getValue(), maxBoost)));
            ComplexExplanation res = new ComplexExplanation(true, score, "function score, product of:");
            ComplexExplanation innerMinExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost), "Math.min of");
            innerMinExpl.addDetail(funcExpl);
            innerMinExpl.addDetail(new Explanation(maxBoost, "maxBoost"));
            ComplexExplanation outerMinExpl = new ComplexExplanation(true, Math.min(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), "min of");
            outerMinExpl.addDetail(queryExpl);
            outerMinExpl.addDetail(innerMinExpl);
            res.addDetail(outerMinExpl);
            res.addDetail(new Explanation(queryBoost, "queryBoost"));
            return res;
        }
    };
    public static final /* enum */ CombineFunction MAX = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 6.toFloat(queryBoost * Math.max(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public ComplexExplanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = 6.toFloat(queryBoost * Math.max(queryExpl.getValue(), Math.min(funcExpl.getValue(), maxBoost)));
            ComplexExplanation res = new ComplexExplanation(true, score, "function score, product of:");
            ComplexExplanation innerMinExpl = new ComplexExplanation(true, Math.min(funcExpl.getValue(), maxBoost), "Math.min of");
            innerMinExpl.addDetail(funcExpl);
            innerMinExpl.addDetail(new Explanation(maxBoost, "maxBoost"));
            ComplexExplanation outerMaxExpl = new ComplexExplanation(true, Math.max(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), "max of");
            outerMaxExpl.addDetail(queryExpl);
            outerMaxExpl.addDetail(innerMinExpl);
            res.addDetail(outerMaxExpl);
            res.addDetail(new Explanation(queryBoost, "queryBoost"));
            return res;
        }
    };
    private static final /* synthetic */ CombineFunction[] $VALUES;

    public static CombineFunction[] values() {
        return (CombineFunction[])$VALUES.clone();
    }

    public static CombineFunction valueOf(String name) {
        return Enum.valueOf(CombineFunction.class, name);
    }

    public abstract float combine(double var1, double var3, double var5, double var7);

    public abstract String getName();

    public static float toFloat(double input) {
        assert (CombineFunction.deviation(input) <= 0.001) : "input " + input + " out of float scope for function score deviation: " + CombineFunction.deviation(input);
        return (float)input;
    }

    private static double deviation(double input) {
        float floatVersion = (float)input;
        return Double.compare(floatVersion, input) == 0 || input == 0.0 ? 0.0 : 1.0 - (double)floatVersion / input;
    }

    public abstract ComplexExplanation explain(float var1, Explanation var2, Explanation var3, float var4);

    static {
        $VALUES = new CombineFunction[]{MULT, REPLACE, SUM, AVG, MIN, MAX};
    }
}

