/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.FilterClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.AllDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.NotDocIdSet;

public class XBooleanFilter
extends Filter
implements Iterable<FilterClause> {
    final List<FilterClause> clauses = new ArrayList<FilterClause>();

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSetIterator it;
        ResultClause clause;
        int i;
        FixedBitSet res = null;
        AtomicReader reader = context.reader();
        if (this.clauses.size() == 1) {
            FilterClause clause2 = this.clauses.get(0);
            DocIdSet set = clause2.getFilter().getDocIdSet(context, acceptDocs);
            if (clause2.getOccur() == BooleanClause.Occur.MUST_NOT) {
                if (DocIdSets.isEmpty(set)) {
                    return new AllDocIdSet(reader.maxDoc());
                }
                return new NotDocIdSet(set, reader.maxDoc());
            }
            if (DocIdSets.isEmpty(set)) {
                return null;
            }
            return set;
        }
        ArrayList<ResultClause> results = new ArrayList<ResultClause>(this.clauses.size());
        boolean hasShouldClauses = false;
        boolean hasNonEmptyShouldClause = false;
        boolean hasMustClauses = false;
        boolean hasMustNotClauses = false;
        for (int i2 = 0; i2 < this.clauses.size(); ++i2) {
            FilterClause clause3 = this.clauses.get(i2);
            DocIdSet set = clause3.getFilter().getDocIdSet(context, acceptDocs);
            if (clause3.getOccur() == BooleanClause.Occur.MUST) {
                hasMustClauses = true;
                if (DocIdSets.isEmpty(set)) {
                    return null;
                }
            } else if (clause3.getOccur() == BooleanClause.Occur.SHOULD) {
                hasShouldClauses = true;
                if (DocIdSets.isEmpty(set)) continue;
                hasNonEmptyShouldClause = true;
            } else if (clause3.getOccur() == BooleanClause.Occur.MUST_NOT) {
                hasMustNotClauses = true;
                if (DocIdSets.isEmpty(set)) {
                    results.add(new ResultClause(null, null, clause3));
                    continue;
                }
            }
            Bits bits = null;
            if (!DocIdSets.isFastIterator(set)) {
                bits = set.bits();
            }
            results.add(new ResultClause(set, bits, clause3));
        }
        if (hasShouldClauses && !hasNonEmptyShouldClause) {
            return null;
        }
        hasNonEmptyShouldClause = false;
        boolean hasBits = false;
        ArrayList<ResultClause> fastOrClauses = new ArrayList<ResultClause>();
        for (i = 0; i < results.size(); ++i) {
            clause = (ResultClause)results.get(i);
            if (clause.bits != null) {
                hasBits = true;
                continue;
            }
            if (clause.clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
            if (hasMustClauses || hasMustNotClauses) {
                fastOrClauses.add(clause);
                continue;
            }
            if (res == null) {
                it = clause.docIdSet.iterator();
                if (it == null) continue;
                hasNonEmptyShouldClause = true;
                res = new FixedBitSet(reader.maxDoc());
                res.or(it);
                continue;
            }
            it = clause.docIdSet.iterator();
            if (it == null) continue;
            hasNonEmptyShouldClause = true;
            res.or(it);
        }
        for (i = 0; i < results.size(); ++i) {
            clause = (ResultClause)results.get(i);
            if (clause.bits != null) {
                hasBits = true;
                continue;
            }
            if (clause.clause.getOccur() == BooleanClause.Occur.MUST) {
                it = clause.docIdSet.iterator();
                if (it == null) {
                    return null;
                }
                if (res == null) {
                    res = new FixedBitSet(reader.maxDoc());
                    res.or(it);
                    continue;
                }
                res.and(it);
                continue;
            }
            if (clause.clause.getOccur() != BooleanClause.Occur.MUST_NOT) continue;
            if (res == null) {
                res = new FixedBitSet(reader.maxDoc());
                res.set(0, reader.maxDoc());
            }
            if (clause.docIdSet == null || (it = clause.docIdSet.iterator()) == null) continue;
            res.andNot(it);
        }
        if (!hasBits) {
            if (!fastOrClauses.isEmpty()) {
                DocIdSetIterator it2 = res.iterator();
                int setDoc = it2.nextDoc();
                while (setDoc != Integer.MAX_VALUE) {
                    block47: {
                        for (ResultClause fastOrClause : fastOrClauses) {
                            DocIdSetIterator clauseIterator = fastOrClause.iterator();
                            if (clauseIterator == null || !XBooleanFilter.iteratorMatch(clauseIterator, setDoc)) continue;
                            hasNonEmptyShouldClause = true;
                            break block47;
                        }
                        res.clear(setDoc);
                    }
                    setDoc = it2.nextDoc();
                }
            }
            if (hasShouldClauses && !hasNonEmptyShouldClause) {
                return null;
            }
            return res;
        }
        ArrayList<ResultClause> slowOrClauses = new ArrayList<ResultClause>();
        for (int i3 = 0; i3 < results.size(); ++i3) {
            int doc;
            DocIdSetIterator it3;
            ResultClause clause4 = (ResultClause)results.get(i3);
            if (clause4.bits == null) continue;
            if (clause4.clause.getOccur() == BooleanClause.Occur.SHOULD) {
                if (hasMustClauses || hasMustNotClauses) {
                    slowOrClauses.add(clause4);
                    continue;
                }
                if (res == null) {
                    DocIdSetIterator it4 = clause4.docIdSet.iterator();
                    if (it4 == null) continue;
                    hasNonEmptyShouldClause = true;
                    res = new FixedBitSet(reader.maxDoc());
                    res.or(it4);
                    continue;
                }
                for (int doc2 = 0; doc2 < reader.maxDoc(); ++doc2) {
                    if (res.get(doc2) || !clause4.bits.get(doc2)) continue;
                    hasNonEmptyShouldClause = true;
                    res.set(doc2);
                }
                continue;
            }
            if (clause4.clause.getOccur() == BooleanClause.Occur.MUST) {
                if (res == null) {
                    res = new FixedBitSet(reader.maxDoc());
                    DocIdSetIterator it5 = clause4.docIdSet.iterator();
                    if (it5 == null) {
                        return null;
                    }
                    res.or(it5);
                    continue;
                }
                Bits bits = clause4.bits;
                it3 = res.iterator();
                doc = it3.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!bits.get(doc)) {
                        res.clear(doc);
                    }
                    doc = it3.nextDoc();
                }
                continue;
            }
            if (clause4.clause.getOccur() != BooleanClause.Occur.MUST_NOT) continue;
            if (res == null) {
                res = new FixedBitSet(reader.maxDoc());
                res.set(0, reader.maxDoc());
                DocIdSetIterator it6 = clause4.docIdSet.iterator();
                if (it6 == null) continue;
                res.andNot(it6);
                continue;
            }
            Bits bits = clause4.bits;
            it3 = res.iterator();
            doc = it3.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (bits.get(doc)) {
                    res.clear(doc);
                }
                doc = it3.nextDoc();
            }
        }
        if (!slowOrClauses.isEmpty() || !fastOrClauses.isEmpty()) {
            DocIdSetIterator it7 = res.iterator();
            int setDoc = it7.nextDoc();
            while (setDoc != Integer.MAX_VALUE) {
                block48: {
                    for (ResultClause fastOrClause : fastOrClauses) {
                        DocIdSetIterator clauseIterator = fastOrClause.iterator();
                        if (clauseIterator == null || !XBooleanFilter.iteratorMatch(clauseIterator, setDoc)) continue;
                        hasNonEmptyShouldClause = true;
                        break block48;
                    }
                    for (ResultClause slowOrClause : slowOrClauses) {
                        if (!slowOrClause.bits.get(setDoc)) continue;
                        hasNonEmptyShouldClause = true;
                        break block48;
                    }
                    res.clear(setDoc);
                }
                setDoc = it7.nextDoc();
            }
        }
        if (hasShouldClauses && !hasNonEmptyShouldClause) {
            return null;
        }
        return res;
    }

    public void add(FilterClause filterClause) {
        this.clauses.add(filterClause);
    }

    public final void add(Filter filter, BooleanClause.Occur occur) {
        this.add(new FilterClause(filter, occur));
    }

    public List<FilterClause> clauses() {
        return this.clauses;
    }

    @Override
    public final Iterator<FilterClause> iterator() {
        return this.clauses().iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        XBooleanFilter other = (XBooleanFilter)obj;
        return this.clauses.equals(other.clauses);
    }

    public int hashCode() {
        return 0x272B5EB6 ^ this.clauses.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BooleanFilter(");
        int minLen = buffer.length();
        for (FilterClause c : this.clauses) {
            if (buffer.length() > minLen) {
                buffer.append(' ');
            }
            buffer.append(c);
        }
        return buffer.append(')').toString();
    }

    static boolean iteratorMatch(DocIdSetIterator docIdSetIterator, int target) throws IOException {
        assert (docIdSetIterator != null);
        int current = docIdSetIterator.docID();
        if (current == Integer.MAX_VALUE || target < current) {
            return false;
        }
        if (current == target) {
            return true;
        }
        return docIdSetIterator.advance(target) == target;
    }

    static class ResultClause {
        public final DocIdSet docIdSet;
        public final Bits bits;
        public final FilterClause clause;
        DocIdSetIterator docIdSetIterator;

        ResultClause(DocIdSet docIdSet, Bits bits, FilterClause clause) {
            this.docIdSet = docIdSet;
            this.bits = bits;
            this.clause = clause;
        }

        DocIdSetIterator iterator() throws IOException {
            if (this.docIdSetIterator != null) {
                return this.docIdSetIterator;
            }
            this.docIdSetIterator = this.docIdSet.iterator();
            return this.docIdSetIterator;
        }
    }
}

