/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.XCollector;

public class FilteredCollector
extends XCollector {
    private final Collector collector;
    private final Filter filter;
    private Bits docSet;

    public FilteredCollector(Collector collector, Filter filter) {
        this.collector = collector;
        this.filter = filter;
    }

    @Override
    public void postCollection() throws IOException {
        if (this.collector instanceof XCollector) {
            ((XCollector)this.collector).postCollection();
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docSet.get(doc)) {
            this.collector.collect(doc);
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.collector.setNextReader(context);
        this.docSet = DocIdSets.toSafeBits(context.reader(), this.filter.getDocIdSet(context, null));
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }
}

