/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.Queries;

public class FilterableTermsEnum
extends TermsEnum {
    static final String UNSUPPORTED_MESSAGE = "This TermsEnum only supports #seekExact(BytesRef) as well as #docFreq() and #totalTermFreq()";
    protected static final int NOT_FOUND = -1;
    private final Holder[] enums;
    protected int currentDocFreq = 0;
    protected long currentTotalTermFreq = 0L;
    protected BytesRef current;
    protected final int docsEnumFlag;
    protected int numDocs;

    public FilterableTermsEnum(IndexReader reader, String field, int docsEnumFlag, @Nullable Filter filter) throws IOException {
        if (docsEnumFlag != 1 && docsEnumFlag != 0) {
            throw new ElasticsearchIllegalArgumentException("invalid docsEnumFlag of " + docsEnumFlag);
        }
        this.docsEnumFlag = docsEnumFlag;
        if (filter == null) {
            this.numDocs = reader.maxDoc();
        }
        ApplyAcceptedDocsFilter acceptedDocsFilter = filter == null ? null : new ApplyAcceptedDocsFilter(filter);
        List<AtomicReaderContext> leaves = reader.leaves();
        ArrayList<Holder> enums = Lists.newArrayListWithExpectedSize(leaves.size());
        for (AtomicReaderContext context : leaves) {
            TermsEnum termsEnum;
            Terms terms = context.reader().terms(field);
            if (terms == null || (termsEnum = terms.iterator(null)) == null) continue;
            Bits bits = null;
            if (acceptedDocsFilter != null) {
                if (acceptedDocsFilter.filter() == Queries.MATCH_ALL_FILTER) {
                    bits = context.reader().getLiveDocs();
                } else {
                    DocIdSet docIdSet = acceptedDocsFilter.getDocIdSet(context, context.reader().getLiveDocs());
                    if (DocIdSets.isEmpty(docIdSet)) continue;
                    bits = DocIdSets.toSafeBits(context.reader(), docIdSet);
                    DocIdSetIterator iterator = docIdSet.iterator();
                    if (iterator != null) {
                        while (iterator.nextDoc() != Integer.MAX_VALUE) {
                            ++this.numDocs;
                        }
                    }
                }
            }
            enums.add(new Holder(termsEnum, bits));
        }
        this.enums = enums.toArray(new Holder[enums.size()]);
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public BytesRef term() throws IOException {
        return this.current;
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        int docFreq = 0;
        long totalTermFreq = 0L;
        for (Holder anEnum : this.enums) {
            int docId;
            if (!anEnum.termsEnum.seekExact(text)) continue;
            if (anEnum.bits == null) {
                docFreq += anEnum.termsEnum.docFreq();
                if (this.docsEnumFlag != 1) continue;
                long leafTotalTermFreq = anEnum.termsEnum.totalTermFreq();
                if (totalTermFreq == -1L || leafTotalTermFreq == -1L) {
                    totalTermFreq = -1L;
                    continue;
                }
                totalTermFreq += leafTotalTermFreq;
                continue;
            }
            DocsEnum docsEnum = anEnum.docsEnum = anEnum.termsEnum.docs(anEnum.bits, anEnum.docsEnum, this.docsEnumFlag);
            if (this.docsEnumFlag == 1) {
                docId = docsEnum.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    ++docFreq;
                    totalTermFreq += (long)docsEnum.freq();
                    docId = docsEnum.nextDoc();
                }
                continue;
            }
            docId = docsEnum.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                ++docFreq;
                docId = docsEnum.nextDoc();
            }
        }
        if (docFreq > 0) {
            this.currentDocFreq = docFreq;
            this.currentTotalTermFreq = totalTermFreq;
            this.current = text;
            return true;
        }
        this.currentDocFreq = -1;
        this.currentTotalTermFreq = -1L;
        this.current = null;
        return false;
    }

    @Override
    public int docFreq() throws IOException {
        return this.currentDocFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.currentTotalTermFreq;
    }

    @Override
    public void seekExact(long ord) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public long ord() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public BytesRef next() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    static class Holder {
        final TermsEnum termsEnum;
        @Nullable
        DocsEnum docsEnum;
        @Nullable
        final Bits bits;

        Holder(TermsEnum termsEnum, Bits bits) {
            this.termsEnum = termsEnum;
            this.bits = bits;
        }
    }
}

