/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Nullable;

public class DocIdSets {
    public static long sizeInBytes(DocIdSet docIdSet) {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + docIdSet.ramBytesUsed();
    }

    public static boolean isEmpty(@Nullable DocIdSet set) {
        return set == null || set == DocIdSet.EMPTY;
    }

    public static boolean isFastIterator(DocIdSet set) {
        return set instanceof FixedBitSet;
    }

    public static DocIdSet toCacheable(AtomicReader reader, @Nullable DocIdSet set) throws IOException {
        if (set == null || set == DocIdSet.EMPTY) {
            return DocIdSet.EMPTY;
        }
        DocIdSetIterator it = set.iterator();
        if (it == null) {
            return DocIdSet.EMPTY;
        }
        int doc = it.nextDoc();
        if (doc == Integer.MAX_VALUE) {
            return DocIdSet.EMPTY;
        }
        if (set instanceof FixedBitSet) {
            return set;
        }
        FixedBitSet fixedBitSet = new FixedBitSet(reader.maxDoc());
        do {
            fixedBitSet.set(doc);
        } while ((doc = it.nextDoc()) != Integer.MAX_VALUE);
        return fixedBitSet;
    }

    public static Bits toSafeBits(AtomicReader reader, @Nullable DocIdSet set) throws IOException {
        if (set == null) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        Bits bits = set.bits();
        if (bits != null) {
            return bits;
        }
        DocIdSetIterator iterator = set.iterator();
        if (iterator == null) {
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        return DocIdSets.toFixedBitSet(iterator, reader.maxDoc());
    }

    public static FixedBitSet toFixedBitSet(DocIdSetIterator iterator, int numBits) throws IOException {
        int doc;
        FixedBitSet set = new FixedBitSet(numBits);
        while ((doc = iterator.nextDoc()) != Integer.MAX_VALUE) {
            set.set(doc);
        }
        return set;
    }
}

