/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.search.XCollector;

public class MultiCollector
extends XCollector {
    private final Collector collector;
    private final Collector[] collectors;

    public MultiCollector(Collector collector, Collector[] collectors) {
        this.collector = collector;
        this.collectors = collectors;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.collector.setScorer(scorer);
        for (Collector collector : this.collectors) {
            collector.setScorer(scorer);
        }
    }

    @Override
    public void collect(int doc) throws IOException {
        this.collector.collect(doc);
        for (Collector collector : this.collectors) {
            collector.collect(doc);
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.collector.setNextReader(context);
        for (Collector collector : this.collectors) {
            collector.setNextReader(context);
        }
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        if (!this.collector.acceptsDocsOutOfOrder()) {
            return false;
        }
        for (Collector collector : this.collectors) {
            if (collector.acceptsDocsOutOfOrder()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void postCollection() throws IOException {
        if (this.collector instanceof XCollector) {
            ((XCollector)this.collector).postCollection();
        }
        for (Collector collector : this.collectors) {
            if (!(collector instanceof XCollector)) continue;
            ((XCollector)collector).postCollection();
        }
    }
}

