/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexWriterConfig;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.NoMergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentInfos;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ComplexExplanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TimeLimitingCollector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TopFieldDocs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TotalHitCountCollector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Lock;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.LockObtainFailedException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Counter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;

public class Lucene {
    public static final org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version VERSION;
    public static final org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version ANALYZER_VERSION;
    public static final org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version QUERYPARSER_VERSION;
    public static final String LATEST_POSTINGS_FORMAT = "Lucene41";
    public static final NamedAnalyzer STANDARD_ANALYZER;
    public static final NamedAnalyzer KEYWORD_ANALYZER;
    public static final ScoreDoc[] EMPTY_SCORE_DOCS;
    public static final TopDocs EMPTY_TOP_DOCS;

    public static org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version parseVersion(@Nullable String version, org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version defaultVersion, ESLogger logger) {
        if (version == null) {
            return defaultVersion;
        }
        try {
            return org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.parse(version);
        }
        catch (ParseException e) {
            logger.warn("no version match {}, default to {}", version, defaultVersion, e);
            return defaultVersion;
        }
    }

    public static SegmentInfos readSegmentInfos(Directory directory) throws IOException {
        SegmentInfos sis = new SegmentInfos();
        sis.read(directory);
        return sis;
    }

    public static Iterable<String> files(SegmentInfos infos) throws IOException {
        ArrayList<Collection<String>> list = new ArrayList<Collection<String>>();
        list.add(Collections.singleton(infos.getSegmentsFileName()));
        for (SegmentCommitInfo info : infos) {
            list.add(info.files());
        }
        return Iterables.concat(list.toArray(new Collection[0]));
    }

    public static int getNumDocs(SegmentInfos info) {
        int numDocs = 0;
        for (SegmentCommitInfo si : info) {
            numDocs += si.info.getDocCount() - si.getDelCount();
        }
        return numDocs;
    }

    public static SegmentInfos readSegmentInfos(IndexCommit commit, Directory directory) throws IOException {
        SegmentInfos sis = new SegmentInfos();
        sis.read(directory, commit.getSegmentsFileName());
        return sis;
    }

    private static SegmentInfos readSegmentInfos(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos sis = new SegmentInfos();
        sis.read(directory, segmentsFileName);
        return sis;
    }

    public static Lock acquireWriteLock(Directory directory) throws IOException {
        return Lucene.acquireLock(directory, "write.lock", IndexWriterConfig.getDefaultWriteLockTimeout());
    }

    public static Lock acquireLock(Directory directory, String lockName, long timeout) throws IOException {
        Lock writeLock = directory.makeLock(lockName);
        if (!writeLock.obtain(timeout)) {
            throw new LockObtainFailedException("failed to obtain lock: " + writeLock);
        }
        return writeLock;
    }

    public static SegmentInfos pruneUnreferencedFiles(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos si = Lucene.readSegmentInfos(segmentsFileName, directory);
        int foundSegmentFiles = 0;
        try (Lock writeLock = Lucene.acquireWriteLock(directory);){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                ++foundSegmentFiles;
                if (file.equals(si.getSegmentsFileName())) continue;
                directory.deleteFile(file);
            }
            assert (SegmentInfos.getLastCommitSegmentsFileName(directory).equals(segmentsFileName));
            if (foundSegmentFiles == 0) {
                throw new IllegalStateException("no commit found in the directory");
            }
        }
        CommitPoint cp = new CommitPoint(si, directory);
        IndexWriter iw = new IndexWriter(directory, new IndexWriterConfig(org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.LATEST, STANDARD_ANALYZER).setIndexCommit(cp).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
        iw.rollback();
        return si;
    }

    public static void cleanLuceneIndex(Directory directory) throws IOException {
        try (Lock writeLock = Lucene.acquireWriteLock(directory);){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                directory.deleteFile(file);
            }
        }
        IndexWriter iw = new IndexWriter(directory, new IndexWriterConfig(org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.LATEST, STANDARD_ANALYZER).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        iw.rollback();
    }

    public static void checkSegmentInfoIntegrity(final Directory directory) throws IOException {
        new SegmentInfos.FindSegmentsFile(directory){

            @Override
            protected Object doBody(String segmentFileName) throws IOException {
                try (IndexInput input = directory.openInput(segmentFileName, IOContext.READ);){
                    int actualFormat;
                    int format = input.readInt();
                    if (format == 1071082519 && (actualFormat = CodecUtil.checkHeaderNoMagic(input, "segments", 0, Integer.MAX_VALUE)) >= 2) {
                        CodecUtil.checksumEntireFile(input);
                    }
                }
                return null;
            }
        }.run();
    }

    public static long count(IndexSearcher searcher, Query query) throws IOException {
        TotalHitCountCollector countCollector = new TotalHitCountCollector();
        query = Lucene.wrapCountQuery(query);
        searcher.search(query, countCollector);
        return countCollector.getTotalHits();
    }

    public static long count(IndexSearcher searcher, Query query, int terminateAfterCount) throws IOException {
        EarlyTerminatingCollector countCollector = Lucene.createCountBasedEarlyTerminatingCollector(terminateAfterCount);
        Lucene.countWithEarlyTermination(searcher, query, countCollector);
        return countCollector.count();
    }

    public static final EarlyTerminatingCollector createCountBasedEarlyTerminatingCollector(int maxCountHits) {
        return new EarlyTerminatingCollector(maxCountHits);
    }

    public static final EarlyTerminatingCollector wrapCountBasedEarlyTerminatingCollector(Collector delegate, int maxCountHits) {
        return new EarlyTerminatingCollector(delegate, maxCountHits);
    }

    public static final TimeLimitingCollector wrapTimeLimitingCollector(Collector delegate, Counter counter, long timeoutInMillis) {
        return new TimeLimitingCollector(delegate, counter, timeoutInMillis);
    }

    public static boolean exists(IndexSearcher searcher, Query query, Filter filter, EarlyTerminatingCollector collector) throws IOException {
        collector.reset();
        Lucene.countWithEarlyTermination(searcher, filter, query, collector);
        return collector.exists();
    }

    public static boolean exists(IndexSearcher searcher, Query query, EarlyTerminatingCollector collector) throws IOException {
        collector.reset();
        Lucene.countWithEarlyTermination(searcher, query, collector);
        return collector.exists();
    }

    public static boolean countWithEarlyTermination(IndexSearcher searcher, Query query, EarlyTerminatingCollector collector) throws IOException {
        return Lucene.countWithEarlyTermination(searcher, null, query, collector);
    }

    public static boolean countWithEarlyTermination(IndexSearcher searcher, Filter filter, Query query, EarlyTerminatingCollector collector) throws IOException {
        query = Lucene.wrapCountQuery(query);
        try {
            if (filter == null) {
                searcher.search(query, collector);
            } else {
                searcher.search(query, filter, (Collector)collector);
            }
        }
        catch (EarlyTerminationException e) {
            return true;
        }
        return false;
    }

    public static final EarlyTerminatingCollector createExistsCollector() {
        return Lucene.createCountBasedEarlyTerminatingCollector(1);
    }

    private static final Query wrapCountQuery(Query query) {
        if (!(query instanceof ConstantScoreQuery)) {
            query = new ConstantScoreQuery(query);
        }
        return query;
    }

    public static boolean safeClose(IndexWriter writer) {
        if (writer == null) {
            return true;
        }
        try {
            writer.close();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static TopDocs readTopDocs(StreamInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            int totalHits = in.readVInt();
            float maxScore = in.readFloat();
            SortField[] fields = new SortField[in.readVInt()];
            for (int i = 0; i < fields.length; ++i) {
                String field = null;
                if (in.readBoolean()) {
                    field = in.readString();
                }
                fields[i] = new SortField(field, Lucene.readSortType(in), in.readBoolean());
            }
            ScoreDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
            }
            return new TopFieldDocs(totalHits, fieldDocs, fields, maxScore);
        }
        int totalHits = in.readVInt();
        float maxScore = in.readFloat();
        ScoreDoc[] scoreDocs = new ScoreDoc[in.readVInt()];
        for (int i = 0; i < scoreDocs.length; ++i) {
            scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
        }
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public static FieldDoc readFieldDoc(StreamInput in) throws IOException {
        Object[] cFields = new Comparable[in.readVInt()];
        for (int j = 0; j < cFields.length; ++j) {
            byte type = in.readByte();
            if (type == 0) {
                cFields[j] = null;
                continue;
            }
            if (type == 1) {
                cFields[j] = in.readString();
                continue;
            }
            if (type == 2) {
                cFields[j] = in.readInt();
                continue;
            }
            if (type == 3) {
                cFields[j] = in.readLong();
                continue;
            }
            if (type == 4) {
                cFields[j] = Float.valueOf(in.readFloat());
                continue;
            }
            if (type == 5) {
                cFields[j] = in.readDouble();
                continue;
            }
            if (type == 6) {
                cFields[j] = in.readByte();
                continue;
            }
            if (type == 7) {
                cFields[j] = in.readShort();
                continue;
            }
            if (type == 8) {
                cFields[j] = in.readBoolean();
                continue;
            }
            if (type == 9) {
                cFields[j] = in.readBytesRef();
                continue;
            }
            throw new IOException("Can't match type [" + type + "]");
        }
        return new FieldDoc(in.readVInt(), in.readFloat(), cFields);
    }

    public static ScoreDoc readScoreDoc(StreamInput in) throws IOException {
        return new ScoreDoc(in.readVInt(), in.readFloat());
    }

    public static void writeTopDocs(StreamOutput out, TopDocs topDocs, int from) throws IOException {
        if (topDocs.scoreDocs.length - from < 0) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (topDocs instanceof TopFieldDocs) {
            out.writeBoolean(true);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topFieldDocs.fields.length);
            for (SortField sortField : topFieldDocs.fields) {
                if (sortField.getField() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeString(sortField.getField());
                }
                if (sortField.getComparatorSource() != null) {
                    Lucene.writeSortType(out, ((IndexFieldData.XFieldComparatorSource)sortField.getComparatorSource()).reducedType());
                } else {
                    Lucene.writeSortType(out, sortField.getType());
                }
                out.writeBoolean(sortField.getReverse());
            }
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index = 0;
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                if (index++ < from) continue;
                Lucene.writeFieldDoc(out, (FieldDoc)doc);
            }
        } else {
            out.writeBoolean(false);
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index = 0;
            for (ScoreDoc doc : topDocs.scoreDocs) {
                if (index++ < from) continue;
                Lucene.writeScoreDoc(out, doc);
            }
        }
    }

    public static void writeFieldDoc(StreamOutput out, FieldDoc fieldDoc) throws IOException {
        out.writeVInt(fieldDoc.fields.length);
        for (Object field : fieldDoc.fields) {
            if (field == null) {
                out.writeByte((byte)0);
                continue;
            }
            Class<?> type = field.getClass();
            if (type == String.class) {
                out.writeByte((byte)1);
                out.writeString((String)field);
                continue;
            }
            if (type == Integer.class) {
                out.writeByte((byte)2);
                out.writeInt((Integer)field);
                continue;
            }
            if (type == Long.class) {
                out.writeByte((byte)3);
                out.writeLong((Long)field);
                continue;
            }
            if (type == Float.class) {
                out.writeByte((byte)4);
                out.writeFloat(((Float)field).floatValue());
                continue;
            }
            if (type == Double.class) {
                out.writeByte((byte)5);
                out.writeDouble((Double)field);
                continue;
            }
            if (type == Byte.class) {
                out.writeByte((byte)6);
                out.writeByte((Byte)field);
                continue;
            }
            if (type == Short.class) {
                out.writeByte((byte)7);
                out.writeShort((Short)field);
                continue;
            }
            if (type == Boolean.class) {
                out.writeByte((byte)8);
                out.writeBoolean((Boolean)field);
                continue;
            }
            if (type == BytesRef.class) {
                out.writeByte((byte)9);
                out.writeBytesRef((BytesRef)field);
                continue;
            }
            throw new IOException("Can't handle sort field value of type [" + type + "]");
        }
        out.writeVInt(fieldDoc.doc);
        out.writeFloat(fieldDoc.score);
    }

    public static void writeScoreDoc(StreamOutput out, ScoreDoc scoreDoc) throws IOException {
        if (!scoreDoc.getClass().equals(ScoreDoc.class)) {
            throw new ElasticsearchIllegalArgumentException("This method can only be used to serialize a ScoreDoc, not a " + scoreDoc.getClass());
        }
        out.writeVInt(scoreDoc.doc);
        out.writeFloat(scoreDoc.score);
    }

    public static SortField.Type readSortType(StreamInput in) throws IOException {
        return SortField.Type.values()[in.readVInt()];
    }

    public static void writeSortType(StreamOutput out, SortField.Type sortType) throws IOException {
        out.writeVInt(sortType.ordinal());
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        Explanation explanation;
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) && in.readBoolean()) {
            Boolean match = in.readOptionalBoolean();
            explanation = new ComplexExplanation();
            ((ComplexExplanation)explanation).setMatch(match);
        } else {
            explanation = new Explanation();
        }
        explanation.setValue(in.readFloat());
        explanation.setDescription(in.readString());
        if (in.readBoolean()) {
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                explanation.addDetail(Lucene.readExplanation(in));
            }
        }
        return explanation;
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            if (explanation instanceof ComplexExplanation) {
                out.writeBoolean(true);
                out.writeOptionalBoolean(((ComplexExplanation)explanation).getMatch());
            } else {
                out.writeBoolean(false);
            }
        }
        out.writeFloat(explanation.getValue());
        if (explanation.getDescription() == null) {
            throw new ElasticsearchIllegalArgumentException("Explanation descriptions should NOT be null\n[" + explanation.toString() + "]");
        }
        out.writeString(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        if (subExplanations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(subExplanations.length);
            for (Explanation subExp : subExplanations) {
                Lucene.writeExplanation(out, subExp);
            }
        }
    }

    private Lucene() {
    }

    public static final boolean indexExists(Directory directory) throws IOException {
        return DirectoryReader.indexExists(directory);
    }

    public static final boolean waitForIndex(Directory directory, long timeLimitMillis) throws IOException {
        long DELAY = 1000L;
        try {
            for (long waited = 0L; waited < timeLimitMillis; waited += 1000L) {
                if (Lucene.indexExists(directory)) {
                    return true;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return Lucene.indexExists(directory);
    }

    public static boolean isCorruptionException(Throwable t) {
        return ExceptionsHelper.unwrap(t, CorruptIndexException.class) != null;
    }

    public static org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version parseVersionLenient(String toParse, org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version defaultValue) {
        return LenientParser.parse(toParse, defaultValue);
    }

    public static boolean indexNeeds3xUpgrading(Directory directory) throws IOException {
        String segmentsFile = SegmentInfos.getLastCommitSegmentsFileName(directory);
        if (segmentsFile != null) {
            try (IndexInput input = directory.openInput(segmentsFile, IOContext.READONCE);){
                boolean bl = input.readInt() != 1071082519;
                return bl;
            }
        }
        return false;
    }

    public static void upgradeLucene3xSegmentsMetadata(Directory directory) throws IOException {
        try (IndexWriter iw = new IndexWriter(directory, new IndexWriterConfig(org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.LATEST, STANDARD_ANALYZER).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));){
            Map<String, String> commitData = iw.getCommitData();
            iw.setCommitData(commitData);
            iw.commit();
        }
    }

    static {
        ANALYZER_VERSION = VERSION = org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.LATEST;
        QUERYPARSER_VERSION = VERSION;
        STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, new StandardAnalyzer(ANALYZER_VERSION));
        KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, new KeywordAnalyzer());
        EMPTY_SCORE_DOCS = new ScoreDoc[0];
        EMPTY_TOP_DOCS = new TopDocs(0, EMPTY_SCORE_DOCS, 0.0f);
    }

    private static final class CommitPoint
    extends IndexCommit {
        private String segmentsFileName;
        private final Collection<String> files;
        private final Directory dir;
        private final long generation;
        private final Map<String, String> userData;
        private final int segmentCount;

        private CommitPoint(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(dir, true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }

    private static final class LenientParser {
        private LenientParser() {
        }

        public static org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version parse(String toParse, org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version defaultValue) {
            if (Strings.hasLength(toParse)) {
                try {
                    return org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version.parseLeniently(toParse);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }

    public static final class EarlyTerminatingCollector
    extends Collector {
        private final int maxCountHits;
        private final Collector delegate;
        private int count = 0;

        EarlyTerminatingCollector(int maxCountHits) {
            this.maxCountHits = maxCountHits;
            this.delegate = NoopCollector.NOOP_COLLECTOR;
        }

        EarlyTerminatingCollector(Collector delegate, int maxCountHits) {
            this.maxCountHits = maxCountHits;
            this.delegate = delegate == null ? NoopCollector.NOOP_COLLECTOR : delegate;
        }

        public void reset() {
            this.count = 0;
        }

        public int count() {
            return this.count;
        }

        public boolean exists() {
            return this.count > 0;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.delegate.setScorer(scorer);
        }

        @Override
        public void collect(int doc) throws IOException {
            this.delegate.collect(doc);
            if (++this.count >= this.maxCountHits) {
                throw new EarlyTerminationException("early termination [CountBased]");
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
            this.delegate.setNextReader(atomicReaderContext);
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return this.delegate.acceptsDocsOutOfOrder();
        }
    }

    public static final class EarlyTerminationException
    extends ElasticsearchException {
        public EarlyTerminationException(String msg) {
            super(msg);
        }
    }
}

