/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.jts.JtsGeometry;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.BasePolygonBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MultiPolygonBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTIPOLYGON;
    protected final ArrayList<BasePolygonBuilder<?>> polygons = new ArrayList();

    public MultiPolygonBuilder() {
        this(ShapeBuilder.Orientation.RIGHT);
    }

    public MultiPolygonBuilder(ShapeBuilder.Orientation orientation) {
        super(orientation);
    }

    public MultiPolygonBuilder polygon(BasePolygonBuilder<?> polygon) {
        this.polygons.add(polygon);
        return this;
    }

    public InternalPolygonBuilder polygon() {
        return this.polygon(ShapeBuilder.Orientation.RIGHT);
    }

    public InternalPolygonBuilder polygon(ShapeBuilder.Orientation orientation) {
        InternalPolygonBuilder polygon = new InternalPolygonBuilder(this, orientation);
        this.polygon(polygon);
        return polygon;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", MultiPolygonBuilder.TYPE.shapename);
        builder.startArray("coordinates");
        for (BasePolygonBuilder<?> polygon : this.polygons) {
            builder.startArray();
            polygon.coordinatesArray(builder, params);
            builder.endArray();
        }
        builder.endArray();
        return builder.endObject();
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    @Override
    public Shape build() {
        ArrayList<JtsGeometry> shapes = new ArrayList<JtsGeometry>(this.polygons.size());
        if (this.wrapdateline) {
            for (BasePolygonBuilder<?> polygon : this.polygons) {
                for (Coordinate[][] part : polygon.coordinates()) {
                    shapes.add(this.jtsGeometry((Geometry)PolygonBuilder.polygon(FACTORY, part)));
                }
            }
        } else {
            for (BasePolygonBuilder<?> polygon : this.polygons) {
                shapes.add(this.jtsGeometry((Geometry)polygon.toPolygon(FACTORY)));
            }
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, SPATIAL_CONTEXT);
    }

    public static class InternalPolygonBuilder
    extends BasePolygonBuilder<InternalPolygonBuilder> {
        private final MultiPolygonBuilder collection;

        private InternalPolygonBuilder(MultiPolygonBuilder collection, ShapeBuilder.Orientation orientation) {
            super(orientation);
            this.collection = collection;
            this.shell = new BasePolygonBuilder.Ring<InternalPolygonBuilder>(this);
        }

        @Override
        public MultiPolygonBuilder close() {
            super.close();
            return this.collection;
        }
    }
}

