/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.PointCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MultiPointBuilder
extends PointCollection<MultiPointBuilder> {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTIPOINT;

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", MultiPointBuilder.TYPE.shapename);
        builder.field("coordinates");
        super.coordinatesToXcontent(builder, false);
        builder.endObject();
        return builder;
    }

    @Override
    public Shape build() {
        ArrayList<Point> shapes = new ArrayList<Point>(this.points.size());
        for (Coordinate coord : this.points) {
            shapes.add(SPATIAL_CONTEXT.makePoint(coord.x, coord.y));
        }
        return new XShapeCollection(shapes, SPATIAL_CONTEXT);
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }
}

