/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class EnvelopeBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.ENVELOPE;
    protected Coordinate topLeft;
    protected Coordinate bottomRight;

    public EnvelopeBuilder() {
        this(ShapeBuilder.Orientation.RIGHT);
    }

    public EnvelopeBuilder(ShapeBuilder.Orientation orientation) {
        super(orientation);
    }

    public EnvelopeBuilder topLeft(Coordinate topLeft) {
        this.topLeft = topLeft;
        return this;
    }

    public EnvelopeBuilder topLeft(double longitude, double latitude) {
        return this.topLeft(EnvelopeBuilder.coordinate(longitude, latitude));
    }

    public EnvelopeBuilder bottomRight(Coordinate bottomRight) {
        this.bottomRight = bottomRight;
        return this;
    }

    public EnvelopeBuilder bottomRight(double longitude, double latitude) {
        return this.bottomRight(EnvelopeBuilder.coordinate(longitude, latitude));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", EnvelopeBuilder.TYPE.shapename);
        builder.startArray("coordinates");
        EnvelopeBuilder.toXContent(builder, this.topLeft);
        EnvelopeBuilder.toXContent(builder, this.bottomRight);
        builder.endArray();
        return builder.endObject();
    }

    @Override
    public Rectangle build() {
        return SPATIAL_CONTEXT.makeRectangle(this.topLeft.x, this.bottomRight.x, this.bottomRight.y, this.topLeft.y);
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }
}

