/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Circle;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CircleBuilder
extends ShapeBuilder {
    public static final String FIELD_RADIUS = "radius";
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.CIRCLE;
    private DistanceUnit unit;
    private double radius;
    private Coordinate center;

    public CircleBuilder center(Coordinate center) {
        this.center = center;
        return this;
    }

    public CircleBuilder center(double lon, double lat) {
        return this.center(new Coordinate(lon, lat));
    }

    public CircleBuilder radius(String radius) {
        return this.radius(DistanceUnit.Distance.parseDistance(radius));
    }

    public CircleBuilder radius(DistanceUnit.Distance radius) {
        return this.radius(radius.value, radius.unit);
    }

    public CircleBuilder radius(double radius, String unit) {
        return this.radius(radius, DistanceUnit.fromString(unit));
    }

    public CircleBuilder radius(double radius, DistanceUnit unit) {
        this.unit = unit;
        this.radius = radius;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", CircleBuilder.TYPE.shapename);
        builder.field(FIELD_RADIUS, this.unit.toString(this.radius));
        builder.field("coordinates");
        CircleBuilder.toXContent(builder, this.center);
        return builder.endObject();
    }

    @Override
    public Circle build() {
        return SPATIAL_CONTEXT.makeCircle(this.center.x, this.center.y, 360.0 * this.radius / this.unit.getEarthCircumference());
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }
}

