/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.Collection;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.ShapeCollection;

public class XShapeCollection<S extends Shape>
extends ShapeCollection<S> {
    public XShapeCollection(List<S> shapes, SpatialContext ctx) {
        super(shapes, ctx);
    }

    @Override
    protected Rectangle computeBoundingBox(Collection<? extends Shape> shapes, SpatialContext ctx) {
        Rectangle retBox = shapes.iterator().next().getBoundingBox();
        for (Shape shape : shapes) {
            retBox = this.expandBBox(retBox, shape.getBoundingBox());
        }
        return retBox;
    }

    private Rectangle expandBBox(Rectangle bbox, Rectangle expand) {
        if (bbox.equals(expand) || bbox.equals(SpatialContext.GEO.getWorldBounds())) {
            return bbox;
        }
        double minX = bbox.getMinX();
        double eMinX = expand.getMinX();
        double maxX = bbox.getMaxX();
        double eMaxX = expand.getMaxX();
        double minY = bbox.getMinY();
        double eMinY = expand.getMinY();
        double maxY = bbox.getMaxY();
        double eMaxY = expand.getMaxY();
        bbox.reset(Math.min(Math.min(minX, maxX), Math.min(eMinX, eMaxX)), Math.max(Math.max(minX, maxX), Math.max(eMinX, eMaxX)), Math.min(Math.min(minY, maxY), Math.min(eMinY, eMaxY)), Math.max(Math.max(minY, maxY), Math.max(eMinY, eMaxY)));
        return bbox;
    }
}

