/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class CompressedString {
    private final byte[] bytes;
    private int hashCode;

    public CompressedString(BytesReference data) throws IOException {
        Compressor compressor = CompressorFactory.compressor(data);
        if (compressor != null) {
            this.bytes = data.toBytes();
        } else {
            BytesArray bytesArray = data.toBytesArray();
            this.bytes = CompressorFactory.defaultCompressor().compress(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
            assert (CompressorFactory.compressor(this.bytes) != null);
        }
    }

    public CompressedString(byte[] data, int offset, int length) throws IOException {
        this(new BytesArray(data, offset, length));
    }

    public CompressedString(byte[] data) throws IOException {
        this(data, 0, data.length);
    }

    public CompressedString(String str) throws IOException {
        this(new BytesArray(new BytesRef(str)));
    }

    public byte[] compressed() {
        return this.bytes;
    }

    public byte[] uncompressed() {
        Compressor compressor = CompressorFactory.compressor(this.bytes);
        assert (compressor != null);
        try {
            return compressor.uncompress(this.bytes, 0, this.bytes.length);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot decompress compressed string", e);
        }
    }

    public String string() throws IOException {
        return new BytesRef(this.uncompressed()).utf8ToString();
    }

    public static CompressedString readCompressedString(StreamInput in) throws IOException {
        byte[] bytes = new byte[in.readVInt()];
        in.readBytes(bytes, 0, bytes.length);
        return new CompressedString(bytes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.bytes.length);
        out.writeBytes(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedString that = (CompressedString)o;
        if (Arrays.equals(this.compressed(), that.compressed())) {
            return true;
        }
        return Arrays.equals(this.uncompressed(), that.uncompressed());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int h = Arrays.hashCode(this.uncompressed());
            if (h == 0) {
                h = 1;
            }
            this.hashCode = h;
        }
        return this.hashCode;
    }

    public String toString() {
        try {
            return this.string();
        }
        catch (IOException e) {
            return "_na_";
        }
    }
}

