/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.GatheringByteChannel;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;

public interface BytesReference {
    public byte get(int var1);

    public int length();

    public BytesReference slice(int var1, int var2);

    public StreamInput streamInput();

    public void writeTo(OutputStream var1) throws IOException;

    public void writeTo(GatheringByteChannel var1) throws IOException;

    public byte[] toBytes();

    public BytesArray toBytesArray();

    public BytesArray copyBytesArray();

    public ChannelBuffer toChannelBuffer();

    public boolean hasArray();

    public byte[] array();

    public int arrayOffset();

    public String toUtf8();

    public BytesRef toBytesRef();

    public BytesRef copyBytesRef();

    public static class Helper {
        public static boolean bytesEqual(BytesReference a, BytesReference b) {
            if (a == b) {
                return true;
            }
            if (a.length() != b.length()) {
                return false;
            }
            return Helper.bytesEquals(a, b);
        }

        static boolean bytesEquals(BytesReference a, BytesReference b) {
            assert (a.length() == b.length());
            int end = a.length();
            for (int i = 0; i < end; ++i) {
                if (a.get(i) == b.get(i)) continue;
                return false;
            }
            return true;
        }

        public static int bytesHashCode(BytesReference a) {
            if (a.hasArray()) {
                return Helper.hashCode(a.array(), a.arrayOffset(), a.length());
            }
            return Helper.slowHashCode(a);
        }

        static int hashCode(byte[] array, int offset, int length) {
            int result = 1;
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                result = 31 * result + array[i];
            }
            return result;
        }

        static int slowHashCode(BytesReference a) {
            int result = 1;
            int end = a.length();
            for (int i = 0; i < end; ++i) {
                result = 31 * result + a.get(i);
            }
            return result;
        }
    }
}

