/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public class BytesArray
implements BytesReference {
    public static final BytesArray EMPTY = new BytesArray(BytesRef.EMPTY_BYTES, 0, 0);
    private byte[] bytes;
    private int offset;
    private int length;

    public BytesArray(String bytes) {
        BytesRef bytesRef = new BytesRef(bytes);
        this.bytes = bytesRef.bytes;
        this.offset = bytesRef.offset;
        this.length = bytesRef.length;
    }

    public BytesArray(BytesRef bytesRef) {
        this(bytesRef, false);
    }

    public BytesArray(BytesRef bytesRef, boolean deepCopy) {
        if (deepCopy) {
            BytesRef copy = BytesRef.deepCopyOf(bytesRef);
            this.bytes = copy.bytes;
            this.offset = copy.offset;
            this.length = copy.length;
        } else {
            this.bytes = bytesRef.bytes;
            this.offset = bytesRef.offset;
            this.length = bytesRef.length;
        }
    }

    public BytesArray(byte[] bytes) {
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public BytesArray(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte get(int index) {
        return this.bytes[this.offset + index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from < 0 || from + length > this.length) {
            throw new ElasticsearchIllegalArgumentException("can't slice a buffer with length [" + this.length + "], with slice parameters from [" + from + "], length [" + length + "]");
        }
        return new BytesArray(this.bytes, this.offset + from, length);
    }

    @Override
    public StreamInput streamInput() {
        return new BytesStreamInput(this.bytes, this.offset, this.length);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.bytes, this.offset, this.length);
    }

    @Override
    public void writeTo(GatheringByteChannel channel) throws IOException {
        Channels.writeToChannel(this.bytes, this.offset, this.length(), (WritableByteChannel)channel);
    }

    @Override
    public byte[] toBytes() {
        if (this.offset == 0 && this.bytes.length == this.length) {
            return this.bytes;
        }
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    @Override
    public BytesArray toBytesArray() {
        return this;
    }

    @Override
    public BytesArray copyBytesArray() {
        return new BytesArray(Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length));
    }

    @Override
    public ChannelBuffer toChannelBuffer() {
        return ChannelBuffers.wrappedBuffer(this.bytes, this.offset, this.length);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.bytes;
    }

    @Override
    public int arrayOffset() {
        return this.offset;
    }

    @Override
    public String toUtf8() {
        if (this.length == 0) {
            return "";
        }
        return new String(this.bytes, this.offset, this.length, Charsets.UTF_8);
    }

    @Override
    public BytesRef toBytesRef() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    @Override
    public BytesRef copyBytesRef() {
        return new BytesRef(Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length));
    }

    public int hashCode() {
        return BytesReference.Helper.bytesHashCode(this);
    }

    public boolean equals(Object obj) {
        return BytesReference.Helper.bytesEqual(this, (BytesReference)obj);
    }
}

