/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;

public class FsBlobContainer
extends AbstractBlobContainer {
    protected final FsBlobStore blobStore;
    protected final File path;

    public FsBlobContainer(FsBlobStore blobStore, BlobPath blobPath, File path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public File filePath() {
        return this.path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        MapBuilder<String, PlainBlobMetaData> builder = MapBuilder.newMapBuilder();
        blobNamePrefix = blobNamePrefix == null ? "" : blobNamePrefix;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path.toPath(), blobNamePrefix + "*");){
            for (Path file : stream) {
                BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                if (!attrs.isRegularFile()) continue;
                builder.put(file.getFileName().toString(), new PlainBlobMetaData(file.getFileName().toString(), attrs.size()));
            }
        }
        return builder.immutableMap();
    }

    @Override
    public boolean deleteBlob(String blobName) throws IOException {
        return new File(this.path, blobName).delete();
    }

    @Override
    public boolean blobExists(String blobName) {
        return new File(this.path, blobName).exists();
    }

    @Override
    public InputStream openInput(String name) throws IOException {
        return new BufferedInputStream(new FileInputStream(new File(this.path, name)), this.blobStore.bufferSizeInBytes());
    }

    @Override
    public OutputStream createOutput(String blobName) throws IOException {
        final File file = new File(this.path, blobName);
        return new BufferedOutputStream(new FilterOutputStream(new FileOutputStream(file)){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                IOUtils.fsync(file, false);
                IOUtils.fsync(FsBlobContainer.this.path, true);
            }
        }, this.blobStore.bufferSizeInBytes());
    }
}

