/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.LockObtainFailedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeIndexDeletedAction
extends AbstractComponent {
    public static final String INDEX_DELETED_ACTION_NAME = "internal:cluster/node/index/deleted";
    public static final String INDEX_STORE_DELETED_ACTION_NAME = "internal:cluster/node/index_store/deleted";
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final IndicesService indicesService;

    @Inject
    public NodeIndexDeletedAction(Settings settings, ThreadPool threadPool, TransportService transportService, NodeEnvironment nodeEnv, IndicesService indicesService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        transportService.registerHandler(INDEX_DELETED_ACTION_NAME, new NodeIndexDeletedTransportHandler());
        transportService.registerHandler(INDEX_STORE_DELETED_ACTION_NAME, new NodeIndexStoreDeletedTransportHandler());
        this.indicesService = indicesService;
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public void nodeIndexDeleted(final ClusterState clusterState, final String index, final Settings indexSettings, final String nodeId) throws ElasticsearchException {
        final DiscoveryNodes nodes = clusterState.nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Throwable t) {
                    NodeIndexDeletedAction.this.logger.warn("[{}]failed to ack index store deleted for index", t, index);
                }

                @Override
                protected void doRun() throws Exception {
                    NodeIndexDeletedAction.this.innerNodeIndexDeleted(index, nodeId);
                    if (!nodes.localNode().isDataNode()) {
                        NodeIndexDeletedAction.this.logger.trace("[{}] not acking store deletion (not a data node)", new Object[0]);
                        return;
                    }
                    NodeIndexDeletedAction.this.lockIndexAndAck(index, nodes, nodeId, clusterState, indexSettings);
                }
            });
        } else {
            this.transportService.sendRequest(clusterState.nodes().masterNode(), INDEX_DELETED_ACTION_NAME, new NodeIndexDeletedMessage(index, nodeId), EmptyTransportResponseHandler.INSTANCE_SAME);
            if (!nodes.localNode().isDataNode()) {
                this.logger.trace("[{}] not acking store deletion (not a data node)", new Object[0]);
                return;
            }
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Throwable t) {
                    NodeIndexDeletedAction.this.logger.warn("[{}]failed to ack index store deleted for  index", t, index);
                }

                @Override
                protected void doRun() throws Exception {
                    NodeIndexDeletedAction.this.lockIndexAndAck(index, nodes, nodeId, clusterState, indexSettings);
                }
            });
        }
    }

    private void lockIndexAndAck(String index, DiscoveryNodes nodes, String nodeId, ClusterState clusterState, Settings indexSettings) throws IOException {
        try {
            this.indicesService.processPendingDeletes(new Index(index), indexSettings, new TimeValue(30L, TimeUnit.MINUTES));
            if (nodes.localNodeMaster()) {
                this.innerNodeIndexStoreDeleted(index, nodeId);
            } else {
                this.transportService.sendRequest(clusterState.nodes().masterNode(), INDEX_STORE_DELETED_ACTION_NAME, new NodeIndexStoreDeletedMessage(index, nodeId), EmptyTransportResponseHandler.INSTANCE_SAME);
            }
        }
        catch (LockObtainFailedException exc) {
            this.logger.warn("[{}] failed to lock all shards for index - timed out after 30 seconds", index);
        }
    }

    private void innerNodeIndexDeleted(String index, String nodeId) {
        for (Listener listener : this.listeners) {
            listener.onNodeIndexDeleted(index, nodeId);
        }
    }

    private void innerNodeIndexStoreDeleted(String index, String nodeId) {
        for (Listener listener : this.listeners) {
            listener.onNodeIndexStoreDeleted(index, nodeId);
        }
    }

    static class NodeIndexStoreDeletedMessage
    extends TransportRequest {
        String index;
        String nodeId;

        NodeIndexStoreDeletedMessage() {
        }

        NodeIndexStoreDeletedMessage(String index, String nodeId) {
            this.index = index;
            this.nodeId = nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.nodeId = in.readString();
        }
    }

    static class NodeIndexDeletedMessage
    extends TransportRequest {
        String index;
        String nodeId;

        NodeIndexDeletedMessage() {
        }

        NodeIndexDeletedMessage(String index, String nodeId) {
            this.index = index;
            this.nodeId = nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.nodeId = in.readString();
        }
    }

    private class NodeIndexStoreDeletedTransportHandler
    extends BaseTransportRequestHandler<NodeIndexStoreDeletedMessage> {
        private NodeIndexStoreDeletedTransportHandler() {
        }

        @Override
        public NodeIndexStoreDeletedMessage newInstance() {
            return new NodeIndexStoreDeletedMessage();
        }

        @Override
        public void messageReceived(NodeIndexStoreDeletedMessage message, TransportChannel channel) throws Exception {
            NodeIndexDeletedAction.this.innerNodeIndexStoreDeleted(message.index, message.nodeId);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private class NodeIndexDeletedTransportHandler
    extends BaseTransportRequestHandler<NodeIndexDeletedMessage> {
        private NodeIndexDeletedTransportHandler() {
        }

        @Override
        public NodeIndexDeletedMessage newInstance() {
            return new NodeIndexDeletedMessage();
        }

        @Override
        public void messageReceived(NodeIndexDeletedMessage message, TransportChannel channel) throws Exception {
            NodeIndexDeletedAction.this.innerNodeIndexDeleted(message.index, message.nodeId);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onNodeIndexDeleted(String var1, String var2);

        public void onNodeIndexStoreDeleted(String var1, String var2);
    }
}

