/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectLongCursor;
import org.elasticsearch.common.io.stream.BytesStreamInput;

public final class TermVectorFields
extends Fields {
    private final ObjectLongOpenHashMap<String> fieldMap;
    private final BytesReference termVectors;
    final boolean hasTermStatistic;
    final boolean hasFieldStatistic;

    public TermVectorFields(BytesReference headerRef, BytesReference termVectors) throws IOException {
        BytesStreamInput header = new BytesStreamInput(headerRef);
        this.fieldMap = new ObjectLongOpenHashMap();
        String headerString = header.readString();
        assert (headerString.equals("TV"));
        int version = header.readInt();
        assert (version == -1);
        this.hasTermStatistic = header.readBoolean();
        this.hasFieldStatistic = header.readBoolean();
        int numFields = header.readVInt();
        for (int i = 0; i < numFields; ++i) {
            this.fieldMap.put(header.readString(), header.readVLong());
        }
        header.close();
        this.termVectors = termVectors;
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<ObjectLongCursor<String>> iterator = this.fieldMap.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)((ObjectLongCursor)iterator.next()).key;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Terms terms(String field) throws IOException {
        if (!this.fieldMap.containsKey(field)) {
            return null;
        }
        long readOffset = this.fieldMap.lget();
        return new TermVector(this.termVectors, readOffset);
    }

    @Override
    public int size() {
        return this.fieldMap.size();
    }

    int readPotentiallyNegativeVInt(BytesStreamInput stream) throws IOException {
        return stream.readVInt() - 1;
    }

    long readPotentiallyNegativeVLong(BytesStreamInput stream) throws IOException {
        return stream.readVLong() - 1L;
    }

    private final class TermVectorDocsAndPosEnum
    extends DocsAndPositionsEnum {
        private boolean hasPositions;
        private boolean hasOffsets;
        private boolean hasPayloads;
        int curPos = -1;
        int doc = -1;
        private int freq;
        private int[] startOffsets;
        private int[] positions;
        private BytesRefBuilder[] payloads;
        private int[] endOffsets;

        private TermVectorDocsAndPosEnum() {
        }

        private DocsAndPositionsEnum reset(int[] positions, int[] startOffsets, int[] endOffsets, BytesRefBuilder[] payloads, int freq) {
            this.curPos = -1;
            this.doc = -1;
            this.hasPositions = positions != null;
            this.hasOffsets = startOffsets != null;
            this.hasPayloads = payloads != null;
            this.freq = freq;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.payloads = payloads;
            this.positions = positions;
            return this;
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.doc == -1 ? 0 : Integer.MAX_VALUE;
            return this.doc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            while (this.nextDoc() < target && this.doc != Integer.MAX_VALUE) {
            }
            return this.doc;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int startOffset() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasOffsets ? this.startOffsets[this.curPos] : -1;
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.curPos + 1 < this.freq);
            ++this.curPos;
            return this.hasPositions ? this.positions[this.curPos] : -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            BytesRefBuilder payload;
            assert (this.curPos < this.freq && this.curPos >= 0);
            if (this.hasPayloads && (payload = this.payloads[this.curPos]) != null) {
                return payload.get();
            }
            return null;
        }

        @Override
        public int endOffset() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasOffsets ? this.endOffsets[this.curPos] : -1;
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private final class TermVector
    extends Terms {
        private final BytesStreamInput perFieldTermVectorInput;
        private final long readOffset;
        private long numTerms;
        private boolean hasPositions;
        private boolean hasOffsets;
        private boolean hasPayloads;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        private int docCount;

        public TermVector(BytesReference termVectors, long readOffset) throws IOException {
            this.perFieldTermVectorInput = new BytesStreamInput(termVectors);
            this.readOffset = readOffset;
            this.reset();
        }

        private void reset() throws IOException {
            this.perFieldTermVectorInput.reset();
            this.perFieldTermVectorInput.skip(this.readOffset);
            this.numTerms = this.perFieldTermVectorInput.readVLong();
            this.hasPositions = this.perFieldTermVectorInput.readBoolean();
            this.hasOffsets = this.perFieldTermVectorInput.readBoolean();
            this.hasPayloads = this.perFieldTermVectorInput.readBoolean();
            this.sumTotalTermFreq = TermVectorFields.this.hasFieldStatistic ? TermVectorFields.this.readPotentiallyNegativeVLong(this.perFieldTermVectorInput) : -1L;
            this.sumDocFreq = TermVectorFields.this.hasFieldStatistic ? TermVectorFields.this.readPotentiallyNegativeVLong(this.perFieldTermVectorInput) : -1L;
            this.docCount = TermVectorFields.this.hasFieldStatistic ? TermVectorFields.this.readPotentiallyNegativeVInt(this.perFieldTermVectorInput) : -1;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            this.reset();
            return new TermsEnum(){
                int currentTerm = 0;
                int freq = 0;
                int docFreq = -1;
                long totalTermFrequency = -1L;
                int[] positions = new int[1];
                int[] startOffsets = new int[1];
                int[] endOffsets = new int[1];
                BytesRefBuilder[] payloads = new BytesRefBuilder[1];
                final BytesRefBuilder spare = new BytesRefBuilder();

                @Override
                public BytesRef next() throws IOException {
                    if ((long)this.currentTerm++ < TermVector.this.numTerms) {
                        int termVectorSize = TermVector.this.perFieldTermVectorInput.readVInt();
                        this.spare.grow(termVectorSize);
                        TermVector.this.perFieldTermVectorInput.readBytes(this.spare.bytes(), 0, termVectorSize);
                        this.spare.setLength(termVectorSize);
                        if (TermVectorFields.this.hasTermStatistic) {
                            this.docFreq = TermVectorFields.this.readPotentiallyNegativeVInt(TermVector.this.perFieldTermVectorInput);
                            this.totalTermFrequency = TermVectorFields.this.readPotentiallyNegativeVLong(TermVector.this.perFieldTermVectorInput);
                        }
                        this.freq = TermVectorFields.this.readPotentiallyNegativeVInt(TermVector.this.perFieldTermVectorInput);
                        this.growBuffers();
                        this.writeInfos(TermVector.this.perFieldTermVectorInput);
                        return this.spare.get();
                    }
                    return null;
                }

                private void writeInfos(BytesStreamInput input) throws IOException {
                    for (int i = 0; i < this.freq; ++i) {
                        if (TermVector.this.hasPositions) {
                            this.positions[i] = input.readVInt();
                        }
                        if (TermVector.this.hasOffsets) {
                            this.startOffsets[i] = input.readVInt();
                            this.endOffsets[i] = input.readVInt();
                        }
                        if (!TermVector.this.hasPayloads) continue;
                        int payloadLength = input.readVInt();
                        if (this.payloads[i] == null) {
                            this.payloads[i] = new BytesRefBuilder();
                        }
                        this.payloads[i].grow(payloadLength);
                        input.readBytes(this.payloads[i].bytes(), 0, payloadLength);
                        this.payloads[i].setLength(payloadLength);
                    }
                }

                private void growBuffers() {
                    if (TermVector.this.hasPositions) {
                        this.positions = ArrayUtil.grow(this.positions, this.freq);
                    }
                    if (TermVector.this.hasOffsets) {
                        this.startOffsets = ArrayUtil.grow(this.startOffsets, this.freq);
                        this.endOffsets = ArrayUtil.grow(this.endOffsets, this.freq);
                    }
                    if (TermVector.this.hasPayloads && this.payloads.length < this.freq) {
                        this.payloads = Arrays.copyOf(this.payloads, ArrayUtil.oversize(this.freq, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
                    }
                }

                @Override
                public Comparator<BytesRef> getComparator() {
                    return BytesRef.getUTF8SortedAsUnicodeComparator();
                }

                @Override
                public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void seekExact(long ord) throws IOException {
                    throw new UnsupportedOperationException("Seek is not supported");
                }

                @Override
                public BytesRef term() throws IOException {
                    return this.spare.get();
                }

                @Override
                public long ord() throws IOException {
                    throw new UnsupportedOperationException("ordinals are not supported");
                }

                @Override
                public int docFreq() throws IOException {
                    return this.docFreq;
                }

                @Override
                public long totalTermFreq() throws IOException {
                    return this.totalTermFrequency;
                }

                @Override
                public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                    return this.docsAndPositions(liveDocs, reuse instanceof DocsAndPositionsEnum ? (DocsAndPositionsEnum)reuse : null, 0);
                }

                @Override
                public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                    TermVectorDocsAndPosEnum retVal = reuse instanceof TermVectorDocsAndPosEnum ? (TermVectorDocsAndPosEnum)reuse : new TermVectorDocsAndPosEnum();
                    return retVal.reset(TermVector.this.hasPositions ? this.positions : null, TermVector.this.hasOffsets ? this.startOffsets : null, TermVector.this.hasOffsets ? this.endOffsets : null, TermVector.this.hasPayloads ? this.payloads : null, this.freq);
                }
            };
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public long size() throws IOException {
            return this.numTerms;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return this.sumTotalTermFreq;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        @Override
        public int getDocCount() throws IOException {
            return this.docCount;
        }

        @Override
        public boolean hasFreqs() {
            return true;
        }

        @Override
        public boolean hasOffsets() {
            return this.hasOffsets;
        }

        @Override
        public boolean hasPositions() {
            return this.hasPositions;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }
    }
}

