/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.AbstractAsyncAction;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;

public class TransportSearchScrollScanAction
extends AbstractComponent {
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollScanAction(Settings settings, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction
    extends AbstractAsyncAction {
        private final SearchScrollRequest request;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        private volatile AtomicArray<ShardSearchFailure> shardFailures;
        private final AtomicArray<QueryFetchSearchResult> queryFetchResults;
        private final AtomicInteger successfulOps;
        private final AtomicInteger counter;

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollScanAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.getContext().length);
            this.counter = new AtomicInteger(scrollId.getContext().length);
            this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            if (this.shardFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
            ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
            for (int i = 0; i < failures.length; ++i) {
                failures[i] = (ShardSearchFailure)entries.get((int)i).value;
            }
            return failures;
        }

        protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
            }
            this.shardFailures.set(shardIndex, failure);
        }

        public void start() {
            if (this.scrollId.getContext().length == 0) {
                InternalSearchResponse internalResponse = new InternalSearchResponse(new InternalSearchHits(InternalSearchHits.EMPTY, Long.parseLong(this.scrollId.getAttributes().get("total_hits")), 0.0f), null, null, null, false, null);
                this.listener.onResponse(new SearchResponse(internalResponse, this.request.scrollId(), 0, 0, 0L, this.buildShardFailures()));
                return;
            }
            Tuple<String, Long>[] context = this.scrollId.getContext();
            for (int i = 0; i < context.length; ++i) {
                Tuple<String, Long> target = context[i];
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) {
                    this.executePhase(i, node, target.v2());
                    continue;
                }
                if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollScanAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
            for (Tuple<String, Long> target : this.scrollId.getContext()) {
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) continue;
                if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollScanAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
        }

        void executePhase(final int shardIndex, DiscoveryNode node, final long searchId) {
            TransportSearchScrollScanAction.this.searchService.sendExecuteScan(node, TransportSearchHelper.internalScrollSearchRequest(searchId, this.request), new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result) {
                    Objects.requireNonNull(result, "QueryFetchSearchResult can't be null");
                    AsyncAction.this.queryFetchResults.setOnce(shardIndex, result);
                    if (AsyncAction.this.counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onPhaseFailure(t, searchId, shardIndex);
                }
            });
        }

        void onPhaseFailure(Throwable t, long searchId, int shardIndex) {
            if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                TransportSearchScrollScanAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
            }
            this.addShardFailure(shardIndex, new ShardSearchFailure(t));
            this.successfulOps.decrementAndGet();
            if (this.counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures());
                if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollScanAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
        }

        private void innerFinishHim() throws IOException {
            int numberOfHits = 0;
            List<AtomicArray.Entry<QueryFetchSearchResult>> entries = this.queryFetchResults.asList();
            for (AtomicArray.Entry<QueryFetchSearchResult> entry : entries) {
                numberOfHits += ((QueryFetchSearchResult)entry.value).queryResult().topDocs().scoreDocs.length;
            }
            ArrayList<ScoreDoc> docs = new ArrayList<ScoreDoc>(numberOfHits);
            for (AtomicArray.Entry<QueryFetchSearchResult> entry : entries) {
                ScoreDoc[] scoreDocs;
                for (ScoreDoc scoreDoc : scoreDocs = ((QueryFetchSearchResult)entry.value).queryResult().topDocs().scoreDocs) {
                    scoreDoc.shardIndex = entry.index;
                    docs.add(scoreDoc);
                }
            }
            InternalSearchResponse internalResponse = TransportSearchScrollScanAction.this.searchPhaseController.merge(docs.toArray(new ScoreDoc[0]), this.queryFetchResults, this.queryFetchResults);
            ((InternalSearchHits)internalResponse.hits()).totalHits = Long.parseLong(this.scrollId.getAttributes().get("total_hits"));
            for (AtomicArray.Entry<QueryFetchSearchResult> entry : entries) {
                if (((QueryFetchSearchResult)entry.value).queryResult().topDocs().scoreDocs.length >= ((QueryFetchSearchResult)entry.value).queryResult().size()) continue;
                this.queryFetchResults.set(entry.index, null);
            }
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.scrollId.getType(), this.queryFetchResults, this.scrollId.getAttributes());
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

