/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.AbstractAsyncAction;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;

public class TransportSearchScrollQueryAndFetchAction
extends AbstractComponent {
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollQueryAndFetchAction(Settings settings, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction
    extends AbstractAsyncAction {
        private final SearchScrollRequest request;
        private volatile boolean useSlowScroll;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        private volatile AtomicArray<ShardSearchFailure> shardFailures;
        private final AtomicArray<QueryFetchSearchResult> queryFetchResults;
        private final AtomicInteger successfulOps;
        private final AtomicInteger counter;

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollQueryAndFetchAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.getContext().length);
            this.counter = new AtomicInteger(scrollId.getContext().length);
            this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            if (this.shardFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
            ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
            for (int i = 0; i < failures.length; ++i) {
                failures[i] = (ShardSearchFailure)entries.get((int)i).value;
            }
            return failures;
        }

        protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
            }
            this.shardFailures.set(shardIndex, failure);
        }

        public void start() {
            if (this.scrollId.getContext().length == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", null));
                return;
            }
            Tuple<String, Long>[] context = this.scrollId.getContext();
            for (int i = 0; i < context.length; ++i) {
                Tuple<String, Long> target = context[i];
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) {
                    if (node.getVersion().before(ParsedScrollId.SCROLL_SEARCH_AFTER_MINIMUM_VERSION)) {
                        this.useSlowScroll = true;
                    }
                    this.executePhase(i, node, target.v2());
                    continue;
                }
                if (TransportSearchScrollQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryAndFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
            for (Tuple<String, Long> target : this.scrollId.getContext()) {
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) continue;
                if (TransportSearchScrollQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryAndFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
        }

        void executePhase(final int shardIndex, DiscoveryNode node, final long searchId) {
            InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest(searchId, this.request);
            TransportSearchScrollQueryAndFetchAction.this.searchService.sendExecuteFetch(node, internalRequest, new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result) {
                    AsyncAction.this.queryFetchResults.set(shardIndex, result);
                    if (AsyncAction.this.counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onPhaseFailure(t, searchId, shardIndex);
                }
            });
        }

        private void onPhaseFailure(Throwable t, long searchId, int shardIndex) {
            if (TransportSearchScrollQueryAndFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchScrollQueryAndFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
            }
            this.addShardFailure(shardIndex, new ShardSearchFailure(t));
            this.successfulOps.decrementAndGet();
            if (this.counter.decrementAndGet() == 0) {
                if (this.successfulOps.get() == 0) {
                    this.listener.onFailure(new SearchPhaseExecutionException("query_fetch", "all shards failed", this.buildShardFailures()));
                } else {
                    this.finishHim();
                }
            }
        }

        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
            }
        }

        private void innerFinishHim() throws Exception {
            ScoreDoc[] sortedShardList = TransportSearchScrollQueryAndFetchAction.this.searchPhaseController.sortDocs(!this.useSlowScroll, this.queryFetchResults);
            InternalSearchResponse internalResponse = TransportSearchScrollQueryAndFetchAction.this.searchPhaseController.merge(sortedShardList, this.queryFetchResults, this.queryFetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

