/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchDfsQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchDfsQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController, ActionFilters actionFilters) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController, actionFilters);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<DfsSearchResult> {
        final AtomicArray<QuerySearchResult> queryResults;
        final AtomicArray<FetchSearchResult> fetchResults;
        final AtomicArray<IntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
            this.queryResults = new AtomicArray(this.firstResults.length());
            this.fetchResults = new AtomicArray(this.firstResults.length());
            this.docIdsToLoad = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "dfs";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, SearchServiceListener<DfsSearchResult> listener) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteDfs(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() {
            AggregatedDfs dfs = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.aggregateDfs(this.firstResults);
            AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
            for (AtomicArray.Entry entry : this.firstResults.asList()) {
                DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
                DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
                this.executeQuery(entry.index, dfsResult, counter, querySearchRequest, node);
            }
        }

        void executeQuery(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, final QuerySearchRequest querySearchRequest, final DiscoveryNode node) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteQuery(node, querySearchRequest, new SearchServiceListener<QuerySearchResult>(){

                @Override
                public void onResult(QuerySearchResult result) {
                    result.shardTarget(dfsResult.shardTarget());
                    AsyncAction.this.queryResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable t) {
                    try {
                        AsyncAction.this.onQueryFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                    }
                    finally {
                        AsyncAction.this.sendReleaseSearchContext(querySearchRequest.id(), node);
                    }
                }
            });
        }

        void onQueryFailure(Throwable t, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
            if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchDfsQueryThenFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
            }
            this.addShardFailure(shardIndex, dfsResult.shardTarget(), t);
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                if (this.successfulOps.get() == 0) {
                    this.listener.onFailure(new SearchPhaseExecutionException("query", "all shards failed", this.buildShardFailures()));
                } else {
                    this.executeFetchPhase();
                }
            }
        }

        void executeFetchPhase() {
            try {
                this.innerExecuteFetchPhase();
            }
            catch (Throwable e) {
                this.listener.onFailure(new ReduceSearchPhaseException("query", "", e, this.buildShardFailures()));
            }
        }

        void innerExecuteFetchPhase() throws Exception {
            boolean useScroll = !this.useSlowScroll && this.request.scroll() != null;
            this.sortedShardList = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.sortDocs(useScroll, this.queryResults);
            TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
            if (this.docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
                return;
            }
            ScoreDoc[] lastEmittedDocPerShard = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.getLastEmittedDocPerShard(this.request, this.sortedShardList, this.firstResults.length());
            AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
            for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
                QuerySearchResult queryResult = this.queryResults.get(entry.index);
                DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult, entry, lastEmittedDocPerShard);
                this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
            }
        }

        void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final ShardFetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result) {
                    result.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.docIdsToLoad.set(shardIndex, null);
                    AsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
                }
            });
        }

        void onFetchFailure(Throwable t, ShardFetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
            if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchDfsQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
            }
            this.addShardFailure(shardIndex, shardTarget, t);
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        private void finishHim() {
            TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new ActionRunnable<SearchResponse>(this.listener){

                @Override
                public void doRun() throws IOException {
                    InternalSearchResponse internalResponse = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.merge(AsyncAction.this.sortedShardList, AsyncAction.this.queryResults, AsyncAction.this.fetchResults);
                    String scrollId = null;
                    if (AsyncAction.this.request.scroll() != null) {
                        scrollId = TransportSearchHelper.buildScrollId(AsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)AsyncAction.this.firstResults, null);
                    }
                    this.listener.onResponse(new SearchResponse(internalResponse, scrollId, AsyncAction.this.expectedSuccessfulOps, AsyncAction.this.successfulOps.get(), AsyncAction.this.buildTookInMillis(), AsyncAction.this.buildShardFailures()));
                    AsyncAction.this.releaseIrrelevantSearchContexts(AsyncAction.this.queryResults, AsyncAction.this.docIdsToLoad);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable t) {
                    try {
                        ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", t, AsyncAction.this.buildShardFailures());
                        if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                            TransportSearchDfsQueryThenFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                        }
                        super.onFailure(failure);
                    }
                    finally {
                        AsyncAction.this.releaseIrrelevantSearchContexts(AsyncAction.this.queryResults, AsyncAction.this.docIdsToLoad);
                    }
                }
            });
        }
    }
}

