/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

@Deprecated
public class MoreLikeThisRequest
extends ActionRequest<MoreLikeThisRequest>
implements CompositeIndicesRequest {
    private String index;
    private String type;
    private String id;
    private String routing;
    private String[] fields;
    private String minimumShouldMatch = "0%";
    private int minTermFreq = -1;
    private int maxQueryTerms = -1;
    private String[] stopWords = null;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLength = -1;
    private int maxWordLength = -1;
    private float boostTerms = -1.0f;
    private boolean include = false;
    private SearchType searchType = SearchType.DEFAULT;
    private int searchSize = 0;
    private int searchFrom = 0;
    private String[] searchIndices;
    private String[] searchTypes;
    private Scroll searchScroll;
    private BytesReference searchSource;

    MoreLikeThisRequest() {
    }

    public MoreLikeThisRequest(String index) {
        this.index = index;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    void index(String index) {
        this.index = index;
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    @Override
    public List<? extends IndicesRequest> subRequests() {
        ArrayList<IndicesRequest> requests = Lists.newArrayList();
        requests.add(new IndicesRequest(){

            @Override
            public String[] indices() {
                return new String[]{MoreLikeThisRequest.this.index};
            }

            @Override
            public IndicesOptions indicesOptions() {
                return MoreLikeThisRequest.this.indicesOptions();
            }
        });
        requests.add(new IndicesRequest.Replaceable(){

            @Override
            public String[] indices() {
                if (MoreLikeThisRequest.this.searchIndices != null) {
                    return MoreLikeThisRequest.this.searchIndices;
                }
                return new String[]{MoreLikeThisRequest.this.index};
            }

            @Override
            public IndicesRequest indices(String[] indices) {
                MoreLikeThisRequest.access$102(MoreLikeThisRequest.this, indices);
                return this;
            }

            @Override
            public IndicesOptions indicesOptions() {
                return SearchRequest.DEFAULT_INDICES_OPTIONS;
            }
        });
        return requests;
    }

    public MoreLikeThisRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MoreLikeThisRequest id(String id) {
        this.id = id;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public void routing(String routing) {
        this.routing = routing;
    }

    public String[] fields() {
        return this.fields;
    }

    public MoreLikeThisRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public MoreLikeThisRequest minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Deprecated
    public MoreLikeThisRequest percentTermsToMatch(float percentTermsToMatch) {
        return this.minimumShouldMatch(Math.round(percentTermsToMatch * 100.0f) + "%");
    }

    @Deprecated
    public float percentTermsToMatch() {
        if (this.minimumShouldMatch.endsWith("%")) {
            return Float.parseFloat(this.minimumShouldMatch.substring(0, this.minimumShouldMatch.indexOf("%"))) / 100.0f;
        }
        return -1.0f;
    }

    public MoreLikeThisRequest minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public int minTermFreq() {
        return this.minTermFreq;
    }

    public MoreLikeThisRequest maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public int maxQueryTerms() {
        return this.maxQueryTerms;
    }

    public MoreLikeThisRequest stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public String[] stopWords() {
        return this.stopWords;
    }

    public MoreLikeThisRequest minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public MoreLikeThisRequest maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public int maxDocFreq() {
        return this.maxDocFreq;
    }

    public MoreLikeThisRequest minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public int minWordLength() {
        return this.minWordLength;
    }

    public MoreLikeThisRequest maxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
        return this;
    }

    public int maxWordLength() {
        return this.maxWordLength;
    }

    public MoreLikeThisRequest boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public float boostTerms() {
        return this.boostTerms;
    }

    public MoreLikeThisRequest include(boolean include) {
        this.include = include;
        return this;
    }

    public boolean include() {
        return this.include;
    }

    public MoreLikeThisRequest searchSource(SearchSourceBuilder sourceBuilder) {
        this.searchSource = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public MoreLikeThisRequest searchSource(String searchSource) {
        this.searchSource = new BytesArray(searchSource);
        return this;
    }

    public MoreLikeThisRequest searchSource(Map searchSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(searchSource);
            return this.searchSource(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + searchSource + "]", e);
        }
    }

    public MoreLikeThisRequest searchSource(XContentBuilder builder) {
        this.searchSource = builder.bytes();
        return this;
    }

    public MoreLikeThisRequest searchSource(byte[] searchSource) {
        return this.searchSource(searchSource, 0, searchSource.length);
    }

    public MoreLikeThisRequest searchSource(byte[] searchSource, int offset, int length) {
        return this.searchSource(new BytesArray(searchSource, offset, length));
    }

    public MoreLikeThisRequest searchSource(BytesReference searchSource) {
        this.searchSource = searchSource;
        return this;
    }

    public BytesReference searchSource() {
        return this.searchSource;
    }

    public MoreLikeThisRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public MoreLikeThisRequest searchType(String searchType) throws ElasticsearchIllegalArgumentException {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public MoreLikeThisRequest searchIndices(String ... searchIndices) {
        this.searchIndices = searchIndices;
        return this;
    }

    public String[] searchIndices() {
        return this.searchIndices;
    }

    public MoreLikeThisRequest searchTypes(String ... searchTypes) {
        this.searchTypes = searchTypes;
        return this;
    }

    public String[] searchTypes() {
        return this.searchTypes;
    }

    public MoreLikeThisRequest searchScroll(Scroll searchScroll) {
        this.searchScroll = searchScroll;
        return this;
    }

    public Scroll searchScroll() {
        return this.searchScroll;
    }

    public MoreLikeThisRequest searchSize(int size) {
        this.searchSize = size;
        return this;
    }

    public int searchSize() {
        return this.searchSize;
    }

    public MoreLikeThisRequest searchFrom(int from) {
        this.searchFrom = from;
        return this;
    }

    public int searchFrom() {
        return this.searchFrom;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        int size = in.readVInt();
        if (size == 0) {
            this.fields = Strings.EMPTY_ARRAY;
        } else {
            this.fields = new String[size];
            for (i = 0; i < size; ++i) {
                this.fields[i] = in.readString();
            }
        }
        if (in.getVersion().onOrAfter(Version.V_1_5_0)) {
            this.minimumShouldMatch(in.readString());
        } else {
            this.percentTermsToMatch(in.readFloat());
        }
        this.minTermFreq = in.readVInt();
        this.maxQueryTerms = in.readVInt();
        size = in.readVInt();
        if (size > 0) {
            this.stopWords = new String[size];
            for (i = 0; i < size; ++i) {
                this.stopWords[i] = in.readString();
            }
        }
        this.minDocFreq = in.readVInt();
        this.maxDocFreq = in.readVInt();
        this.minWordLength = in.readVInt();
        this.maxWordLength = in.readVInt();
        this.boostTerms = in.readFloat();
        this.include = in.getVersion().onOrAfter(Version.V_1_2_0) ? in.readBoolean() : false;
        this.searchType = SearchType.fromId(in.readByte());
        if (in.getVersion().before(Version.V_1_4_0_Beta1) && in.readBoolean()) {
            in.readString();
        }
        if ((size = in.readVInt()) == 0) {
            this.searchIndices = null;
        } else if (size == 1) {
            this.searchIndices = Strings.EMPTY_ARRAY;
        } else {
            this.searchIndices = new String[size - 1];
            for (i = 0; i < this.searchIndices.length; ++i) {
                this.searchIndices[i] = in.readString();
            }
        }
        size = in.readVInt();
        if (size == 0) {
            this.searchTypes = null;
        } else if (size == 1) {
            this.searchTypes = Strings.EMPTY_ARRAY;
        } else {
            this.searchTypes = new String[size - 1];
            for (i = 0; i < this.searchTypes.length; ++i) {
                this.searchTypes[i] = in.readString();
            }
        }
        if (in.readBoolean()) {
            this.searchScroll = Scroll.readScroll(in);
        }
        this.searchSource = in.readBytesReference();
        this.searchSize = in.readVInt();
        this.searchFrom = in.readVInt();
        this.routing = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.length);
            for (String field : this.fields) {
                out.writeString(field);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_1_5_0)) {
            out.writeString(this.minimumShouldMatch);
        } else {
            out.writeFloat(this.percentTermsToMatch());
        }
        out.writeVInt(this.minTermFreq);
        out.writeVInt(this.maxQueryTerms);
        if (this.stopWords == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.stopWords.length);
            for (String stopWord : this.stopWords) {
                out.writeString(stopWord);
            }
        }
        out.writeVInt(this.minDocFreq);
        out.writeVInt(this.maxDocFreq);
        out.writeVInt(this.minWordLength);
        out.writeVInt(this.maxWordLength);
        out.writeFloat(this.boostTerms);
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeBoolean(this.include);
        }
        out.writeByte(this.searchType.id());
        if (out.getVersion().before(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(false);
        }
        if (this.searchIndices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.searchIndices.length + 1);
            for (String index : this.searchIndices) {
                out.writeString(index);
            }
        }
        if (this.searchTypes == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.searchTypes.length + 1);
            for (String type : this.searchTypes) {
                out.writeString(type);
            }
        }
        if (this.searchScroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.searchScroll.writeTo(out);
        }
        out.writeBytesReference(this.searchSource);
        out.writeVInt(this.searchSize);
        out.writeVInt(this.searchFrom);
        out.writeOptionalString(this.routing);
    }

    static /* synthetic */ String[] access$102(MoreLikeThisRequest x0, String[] x1) {
        x0.searchIndices = x1;
        return x1;
    }
}

