/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.text.ParseException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardUpgradeResponse
extends BroadcastShardOperationResponse {
    private Version version;
    private boolean primary;

    ShardUpgradeResponse() {
    }

    ShardUpgradeResponse(ShardId shardId, boolean primary, Version version) {
        super(shardId);
        this.primary = primary;
        this.version = version;
    }

    public Version version() {
        return this.version;
    }

    public boolean primary() {
        return this.primary;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.primary = in.readBoolean();
        try {
            this.version = Version.parse(in.readString());
        }
        catch (ParseException ex) {
            throw new IOException("failed to parse lucene version [" + this.version + "]", ex);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.primary);
        out.writeString(this.version.toString());
    }
}

