/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.FST;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.FSTEnum;

public final class BytesRefFSTEnum<T>
extends FSTEnum<T> {
    private final BytesRef current = new BytesRef(10);
    private final InputOutput<T> result = new InputOutput();
    private BytesRef target;

    public BytesRefFSTEnum(FST<T> fst) {
        super(fst);
        this.result.input = this.current;
        this.current.offset = 1;
    }

    public InputOutput<T> current() {
        return this.result;
    }

    public InputOutput<T> next() throws IOException {
        this.doNext();
        return this.setResult();
    }

    public InputOutput<T> seekCeil(BytesRef target) throws IOException {
        this.target = target;
        this.targetLength = target.length;
        super.doSeekCeil();
        return this.setResult();
    }

    public InputOutput<T> seekFloor(BytesRef target) throws IOException {
        this.target = target;
        this.targetLength = target.length;
        super.doSeekFloor();
        return this.setResult();
    }

    public InputOutput<T> seekExact(BytesRef target) throws IOException {
        this.target = target;
        this.targetLength = target.length;
        if (super.doSeekExact()) {
            assert (this.upto == 1 + target.length);
            return this.setResult();
        }
        return null;
    }

    @Override
    protected int getTargetLabel() {
        if (this.upto - 1 == this.target.length) {
            return -1;
        }
        return this.target.bytes[this.target.offset + this.upto - 1] & 0xFF;
    }

    @Override
    protected int getCurrentLabel() {
        return this.current.bytes[this.upto] & 0xFF;
    }

    @Override
    protected void setCurrentLabel(int label) {
        this.current.bytes[this.upto] = (byte)label;
    }

    @Override
    protected void grow() {
        this.current.bytes = ArrayUtil.grow(this.current.bytes, this.upto + 1);
    }

    private InputOutput<T> setResult() {
        if (this.upto == 0) {
            return null;
        }
        this.current.length = this.upto - 1;
        this.result.output = this.output[this.upto];
        return this.result;
    }

    public static class InputOutput<T> {
        public BytesRef input;
        public T output;
    }
}

