/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton;

import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.Operations;

public abstract class RunAutomaton {
    final Automaton automaton;
    final int maxInterval;
    final int size;
    final boolean[] accept;
    final int initial;
    final int[] transitions;
    final int[] points;
    final int[] classmap;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("initial state: ").append(this.initial).append("\n");
        for (int i = 0; i < this.size; ++i) {
            b.append("state " + i);
            if (this.accept[i]) {
                b.append(" [accept]:\n");
            } else {
                b.append(" [reject]:\n");
            }
            for (int j = 0; j < this.points.length; ++j) {
                int k = this.transitions[i * this.points.length + j];
                if (k == -1) continue;
                int min = this.points[j];
                int max = j + 1 < this.points.length ? this.points[j + 1] - 1 : this.maxInterval;
                b.append(" ");
                Automaton.appendCharString(min, b);
                if (min != max) {
                    b.append("-");
                    Automaton.appendCharString(max, b);
                }
                b.append(" -> ").append(k).append("\n");
            }
        }
        return b.toString();
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isAccept(int state) {
        return this.accept[state];
    }

    public final int getInitialState() {
        return this.initial;
    }

    public final int[] getCharIntervals() {
        return (int[])this.points.clone();
    }

    final int getCharClass(int c) {
        return Operations.findIndex(c, this.points);
    }

    public RunAutomaton(Automaton a, int maxInterval, boolean tableize) {
        this(a, maxInterval, tableize, 10000);
    }

    public RunAutomaton(Automaton a, int maxInterval, boolean tableize, int maxDeterminizedStates) {
        this.maxInterval = maxInterval;
        this.automaton = a = Operations.determinize(a, maxDeterminizedStates);
        this.points = a.getStartPoints();
        this.initial = 0;
        this.size = Math.max(1, a.getNumStates());
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        Arrays.fill(this.transitions, -1);
        for (int n = 0; n < this.size; ++n) {
            this.accept[n] = a.isAccept(n);
            for (int c = 0; c < this.points.length; ++c) {
                int dest = a.step(n, this.points[c]);
                assert (dest == -1 || dest < this.size);
                this.transitions[n * this.points.length + c] = dest;
            }
        }
        if (tableize) {
            this.classmap = new int[maxInterval + 1];
            int i = 0;
            for (int j = 0; j <= maxInterval; ++j) {
                if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                    // empty if block
                }
                this.classmap[j] = ++i;
            }
        } else {
            this.classmap = null;
        }
    }

    public final int step(int state, int c) {
        if (this.classmap == null) {
            return this.transitions[state * this.points.length + this.getCharClass(c)];
        }
        return this.transitions[state * this.points.length + this.classmap[c]];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.initial;
        result = 31 * result + this.maxInterval;
        result = 31 * result + this.points.length;
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunAutomaton other = (RunAutomaton)obj;
        if (this.initial != other.initial) {
            return false;
        }
        if (this.maxInterval != other.maxInterval) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.points, other.points)) {
            return false;
        }
        if (!Arrays.equals(this.accept, other.accept)) {
            return false;
        }
        return Arrays.equals(this.transitions, other.transitions);
    }
}

