/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.Operations;

public final class Automata {
    private Automata() {
    }

    public static Automaton makeEmpty() {
        Automaton a = new Automaton();
        a.finishState();
        return a;
    }

    public static Automaton makeEmptyString() {
        Automaton a = new Automaton();
        a.createState();
        a.setAccept(0, true);
        return a;
    }

    public static Automaton makeAnyString() {
        Automaton a = new Automaton();
        int s = a.createState();
        a.setAccept(s, true);
        a.addTransition(s, s, 0, 0x10FFFF);
        a.finishState();
        return a;
    }

    public static Automaton makeAnyChar() {
        return Automata.makeCharRange(0, 0x10FFFF);
    }

    public static int appendAnyChar(Automaton a, int state) {
        int newState = a.createState();
        a.addTransition(state, newState, 0, 0x10FFFF);
        return newState;
    }

    public static Automaton makeChar(int c) {
        return Automata.makeCharRange(c, c);
    }

    public static int appendChar(Automaton a, int state, int c) {
        int newState = a.createState();
        a.addTransition(state, newState, c, c);
        return newState;
    }

    public static Automaton makeCharRange(int min, int max) {
        if (min > max) {
            return Automata.makeEmpty();
        }
        Automaton a = new Automaton();
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, min, max);
        a.finishState();
        return a;
    }

    private static int anyOfRightLength(Automaton.Builder builder, String x, int n) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), 48, 57);
        }
        return s;
    }

    private static int atLeast(Automaton.Builder builder, String x, int n, Collection<Integer> initials, boolean zeros) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            if (zeros) {
                initials.add(s);
            }
            char c = x.charAt(n);
            builder.addTransition(s, Automata.atLeast(builder, x, n + 1, initials, zeros && c == '0'), c);
            if (c < '9') {
                builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), (char)(c + '\u0001'), 57);
            }
        }
        return s;
    }

    private static int atMost(Automaton.Builder builder, String x, int n) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            char c = x.charAt(n);
            builder.addTransition(s, Automata.atMost(builder, x, (char)n + '\u0001'), c);
            if (c > '0') {
                builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), 48, (char)(c - '\u0001'));
            }
        }
        return s;
    }

    private static int between(Automaton.Builder builder, String x, String y, int n, Collection<Integer> initials, boolean zeros) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                builder.addTransition(s, Automata.between(builder, x, y, n + 1, initials, zeros && cx == '0'), cx);
            } else {
                builder.addTransition(s, Automata.atLeast(builder, x, n + 1, initials, zeros && cx == '0'), cx);
                builder.addTransition(s, Automata.atMost(builder, y, n + 1), cy);
                if (cx + '\u0001' < cy) {
                    builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), (char)(cx + '\u0001'), (char)(cy - '\u0001'));
                }
            }
        }
        return s;
    }

    public static Automaton makeInterval(int min, int max, int digits) throws IllegalArgumentException {
        String x = Integer.toString(min);
        String y = Integer.toString(max);
        if (min > max || digits > 0 && y.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        for (int i = x.length(); i < d; ++i) {
            bx.append('0');
        }
        bx.append(x);
        x = bx.toString();
        StringBuilder by = new StringBuilder();
        for (int i = y.length(); i < d; ++i) {
            by.append('0');
        }
        by.append(y);
        y = by.toString();
        Automaton.Builder builder = new Automaton.Builder();
        if (digits <= 0) {
            builder.createState();
        }
        ArrayList<Integer> initials = new ArrayList<Integer>();
        Automata.between(builder, x, y, 0, initials, digits <= 0);
        Automaton a1 = builder.finish();
        if (digits <= 0) {
            a1.addTransition(0, 0, 48);
            Iterator i$ = initials.iterator();
            while (i$.hasNext()) {
                int p = (Integer)i$.next();
                a1.addEpsilon(0, p);
            }
            a1.finishState();
        }
        return a1;
    }

    public static Automaton makeString(String s) {
        Automaton a = new Automaton();
        int lastState = a.createState();
        int cp = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            int state = a.createState();
            cp = s.codePointAt(i);
            a.addTransition(lastState, state, cp, cp);
            lastState = state;
        }
        a.setAccept(lastState, true);
        a.finishState();
        assert (a.isDeterministic());
        assert (!Operations.hasDeadStates(a));
        return a;
    }

    public static Automaton makeString(int[] word, int offset, int length) {
        Automaton a = new Automaton();
        a.createState();
        int s = 0;
        for (int i = offset; i < offset + length; ++i) {
            int s2 = a.createState();
            a.addTransition(s, s2, word[i]);
            s = s2;
        }
        a.setAccept(s, true);
        a.finishState();
        return a;
    }

    public static Automaton makeStringUnion(Collection<BytesRef> utf8Strings) {
        if (utf8Strings.isEmpty()) {
            return Automata.makeEmpty();
        }
        return DaciukMihovAutomatonBuilder.build(utf8Strings);
    }
}

