/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BitUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.GrowableByteArrayDataOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.PriorityQueue;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.packed.PackedLongValues;

public final class WAH8DocIdSet
extends DocIdSet
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(WAH8DocIdSet.class);
    private static final int MIN_INDEX_INTERVAL = 8;
    public static final int DEFAULT_INDEX_INTERVAL = 24;
    private static final PackedLongValues SINGLE_ZERO = PackedLongValues.packedBuilder(0.0f).add(0L).build();
    private static WAH8DocIdSet EMPTY = new WAH8DocIdSet(new byte[0], 0, 1, SINGLE_ZERO, SINGLE_ZERO);
    private static final Comparator<Iterator> SERIALIZED_LENGTH_COMPARATOR = new Comparator<Iterator>(){

        @Override
        public int compare(Iterator wi1, Iterator wi2) {
            return wi1.in.length() - wi2.in.length();
        }
    };
    private final byte[] data;
    private final int cardinality;
    private final int indexInterval;
    private final PackedLongValues positions;
    private final PackedLongValues wordNums;

    public static WAH8DocIdSet intersect(Collection<WAH8DocIdSet> docIdSets) {
        return WAH8DocIdSet.intersect(docIdSets, 24);
    }

    public static WAH8DocIdSet intersect(Collection<WAH8DocIdSet> docIdSets, int indexInterval) {
        switch (docIdSets.size()) {
            case 0: {
                throw new IllegalArgumentException("There must be at least one set to intersect");
            }
            case 1: {
                return docIdSets.iterator().next();
            }
        }
        int numSets = docIdSets.size();
        Iterator[] iterators = new Iterator[numSets];
        int i = 0;
        for (WAH8DocIdSet set : docIdSets) {
            Iterator it = set.iterator();
            iterators[i++] = it;
        }
        Arrays.sort(iterators, SERIALIZED_LENGTH_COMPARATOR);
        WordBuilder builder = new WordBuilder().setIndexInterval(indexInterval);
        int wordNum = 0;
        block5: while (true) {
            iterators[0].advanceWord(wordNum);
            wordNum = iterators[0].wordNum;
            if (wordNum == Integer.MAX_VALUE) break;
            byte word = iterators[0].word;
            for (i = 1; i < numSets; ++i) {
                if (iterators[i].wordNum < wordNum) {
                    iterators[i].advanceWord(wordNum);
                }
                if (iterators[i].wordNum > wordNum) {
                    wordNum = iterators[i].wordNum;
                    continue block5;
                }
                assert (iterators[i].wordNum == wordNum);
                if ((word = (byte)(word & iterators[i].word)) != 0) continue;
                ++wordNum;
                continue block5;
            }
            assert (word != 0);
            builder.addWord(wordNum, word);
            ++wordNum;
        }
        return builder.build();
    }

    public static WAH8DocIdSet union(Collection<WAH8DocIdSet> docIdSets) {
        return WAH8DocIdSet.union(docIdSets, 24);
    }

    public static WAH8DocIdSet union(Collection<WAH8DocIdSet> docIdSets, int indexInterval) {
        switch (docIdSets.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return docIdSets.iterator().next();
            }
        }
        int numSets = docIdSets.size();
        PriorityQueue<Iterator> iterators = new PriorityQueue<Iterator>(numSets){

            @Override
            protected boolean lessThan(Iterator a, Iterator b) {
                return a.wordNum < b.wordNum;
            }
        };
        for (WAH8DocIdSet set : docIdSets) {
            Iterator iterator = set.iterator();
            iterator.nextWord();
            iterators.add(iterator);
        }
        Iterator top = (Iterator)iterators.top();
        if (top.wordNum == Integer.MAX_VALUE) {
            return EMPTY;
        }
        int wordNum = top.wordNum;
        byte word = top.word;
        WordBuilder builder = new WordBuilder().setIndexInterval(indexInterval);
        while (true) {
            top.nextWord();
            iterators.updateTop();
            top = (Iterator)iterators.top();
            if (top.wordNum == wordNum) {
                word = (byte)(word | top.word);
                continue;
            }
            builder.addWord(wordNum, word);
            if (top.wordNum == Integer.MAX_VALUE) break;
            wordNum = top.wordNum;
            word = top.word;
        }
        return builder.build();
    }

    static int wordNum(int docID) {
        assert (docID >= 0);
        return docID >>> 3;
    }

    WAH8DocIdSet(byte[] data, int cardinality, int indexInterval, PackedLongValues positions, PackedLongValues wordNums) {
        this.data = data;
        this.cardinality = cardinality;
        this.indexInterval = indexInterval;
        this.positions = positions;
        this.wordNums = wordNums;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(this.data, this.cardinality, this.indexInterval, this.positions, this.wordNums);
    }

    static int readCleanLength(ByteArrayDataInput in, int token) {
        int len = token >>> 4 & 7;
        int startPosition = in.getPosition();
        if ((len & 4) != 0) {
            len = len & 3 | in.readVInt() << 2;
        }
        if (startPosition != 1) {
            len += 2;
        }
        return len;
    }

    static int readDirtyLength(ByteArrayDataInput in, int token) {
        int len = token & 0xF;
        if ((len & 8) != 0) {
            len = len & 7 | in.readVInt() << 3;
        }
        return len;
    }

    public int cardinality() {
        return this.cardinality;
    }

    @Override
    public long ramBytesUsed() {
        if (this == EMPTY) {
            return 0L;
        }
        long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.data);
        if (this.positions != SINGLE_ZERO) {
            ramBytesUsed += this.positions.ramBytesUsed();
        }
        if (this.wordNums != SINGLE_ZERO) {
            ramBytesUsed += this.wordNums.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    static class Iterator
    extends DocIdSetIterator {
        final ByteArrayDataInput in;
        final int cardinality;
        final int indexInterval;
        final PackedLongValues positions;
        final PackedLongValues wordNums;
        final int indexThreshold;
        int allOnesLength;
        int dirtyLength;
        int wordNum;
        byte word;
        int bitList;
        int sequenceNum;
        int docID;

        static int indexThreshold(int cardinality, int indexInterval) {
            long indexThreshold = 9L * (long)indexInterval;
            return (int)Math.min(Integer.MAX_VALUE, indexThreshold);
        }

        Iterator(byte[] data, int cardinality, int indexInterval, PackedLongValues positions, PackedLongValues wordNums) {
            this.in = new ByteArrayDataInput(data);
            this.cardinality = cardinality;
            this.indexInterval = indexInterval;
            this.positions = positions;
            this.wordNums = wordNums;
            this.wordNum = -1;
            this.word = 0;
            this.bitList = 0;
            this.sequenceNum = -1;
            this.docID = -1;
            this.indexThreshold = Iterator.indexThreshold(cardinality, indexInterval);
        }

        boolean readSequence() {
            if (this.in.eof()) {
                this.wordNum = Integer.MAX_VALUE;
                return false;
            }
            int token = this.in.readByte() & 0xFF;
            if ((token & 0x80) == 0) {
                int cleanLength = WAH8DocIdSet.readCleanLength(this.in, token);
                this.wordNum += cleanLength;
            } else {
                this.allOnesLength = WAH8DocIdSet.readCleanLength(this.in, token);
            }
            this.dirtyLength = WAH8DocIdSet.readDirtyLength(this.in, token);
            assert (this.in.length() - this.in.getPosition() >= this.dirtyLength) : this.in.getPosition() + " " + this.in.length() + " " + this.dirtyLength;
            ++this.sequenceNum;
            return true;
        }

        void skipDirtyBytes(int count) {
            assert (count >= 0);
            assert (count <= this.allOnesLength + this.dirtyLength);
            this.wordNum += count;
            if (count <= this.allOnesLength) {
                this.allOnesLength -= count;
            } else {
                this.allOnesLength = 0;
                this.in.skipBytes(count -= this.allOnesLength);
                this.dirtyLength -= count;
            }
        }

        void skipDirtyBytes() {
            this.wordNum += this.allOnesLength + this.dirtyLength;
            this.in.skipBytes(this.dirtyLength);
            this.allOnesLength = 0;
            this.dirtyLength = 0;
        }

        void nextWord() {
            if (this.allOnesLength > 0) {
                this.word = (byte)-1;
                ++this.wordNum;
                --this.allOnesLength;
                return;
            }
            if (this.dirtyLength > 0) {
                this.word = this.in.readByte();
                ++this.wordNum;
                --this.dirtyLength;
                if (this.word != 0) {
                    return;
                }
                if (this.dirtyLength > 0) {
                    this.word = this.in.readByte();
                    ++this.wordNum;
                    --this.dirtyLength;
                    assert (this.word != 0);
                    return;
                }
            }
            if (this.readSequence()) {
                this.nextWord();
            }
        }

        int forwardBinarySearch(int targetWordNum) {
            int indexSize = (int)this.wordNums.size();
            int lo = this.sequenceNum / this.indexInterval;
            int hi = lo + 1;
            assert (this.sequenceNum == -1 || this.wordNums.get(lo) <= (long)this.wordNum);
            assert ((long)(lo + 1) == this.wordNums.size() || this.wordNums.get(lo + 1) > (long)this.wordNum);
            while (true) {
                if (hi >= indexSize) {
                    hi = indexSize - 1;
                    break;
                }
                if (this.wordNums.get(hi) >= (long)targetWordNum) break;
                int newLo = hi;
                hi += hi - lo << 1;
                lo = newLo;
            }
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midWordNum = (int)this.wordNums.get(mid);
                if (midWordNum <= targetWordNum) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            assert (this.wordNums.get(hi) <= (long)targetWordNum);
            assert ((long)(hi + 1) == this.wordNums.size() || this.wordNums.get(hi + 1) > (long)targetWordNum);
            return hi;
        }

        void advanceWord(int targetWordNum) {
            assert (targetWordNum > this.wordNum);
            int delta = targetWordNum - this.wordNum;
            if (delta <= this.allOnesLength + this.dirtyLength + 1) {
                this.skipDirtyBytes(delta - 1);
            } else {
                int i;
                int position;
                this.skipDirtyBytes();
                assert (this.dirtyLength == 0);
                if (delta > this.indexThreshold && (position = (int)this.positions.get(i = this.forwardBinarySearch(targetWordNum))) > this.in.getPosition()) {
                    this.wordNum = (int)this.wordNums.get(i) - 1;
                    this.in.setPosition(position);
                    this.sequenceNum = i * this.indexInterval - 1;
                }
                while (true) {
                    if (!this.readSequence()) {
                        return;
                    }
                    delta = targetWordNum - this.wordNum;
                    if (delta <= this.allOnesLength + this.dirtyLength + 1) {
                        if (delta <= 1) break;
                        this.skipDirtyBytes(delta - 1);
                        break;
                    }
                    this.skipDirtyBytes();
                }
            }
            this.nextWord();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.bitList != 0) {
                this.docID = this.wordNum << 3 | (this.bitList & 0xF) - 1;
                this.bitList >>>= 4;
                return this.docID;
            }
            this.nextWord();
            if (this.wordNum == Integer.MAX_VALUE) {
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.bitList = BitUtil.bitList(this.word);
            assert (this.bitList != 0);
            this.docID = this.wordNum << 3 | (this.bitList & 0xF) - 1;
            this.bitList >>>= 4;
            return this.docID;
        }

        @Override
        public int advance(int target) throws IOException {
            assert (target > this.docID);
            int targetWordNum = WAH8DocIdSet.wordNum(target);
            if (targetWordNum > this.wordNum) {
                this.advanceWord(targetWordNum);
                this.bitList = BitUtil.bitList(this.word);
            }
            return this.slowAdvance(target);
        }

        @Override
        public long cost() {
            return this.cardinality;
        }
    }

    public static final class Builder
    extends WordBuilder {
        private int lastDocID = -1;
        private int wordNum = -1;
        private int word = 0;

        public Builder add(int docID) {
            if (docID <= this.lastDocID) {
                throw new IllegalArgumentException("Doc ids must be added in-order, got " + docID + " which is <= lastDocID=" + this.lastDocID);
            }
            int wordNum = WAH8DocIdSet.wordNum(docID);
            if (this.wordNum == -1) {
                this.wordNum = wordNum;
                this.word = 1 << (docID & 7);
            } else if (wordNum == this.wordNum) {
                this.word |= 1 << (docID & 7);
            } else {
                this.addWord(this.wordNum, (byte)this.word);
                this.wordNum = wordNum;
                this.word = 1 << (docID & 7);
            }
            this.lastDocID = docID;
            return this;
        }

        public Builder add(DocIdSetIterator disi) throws IOException {
            int doc = disi.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.add(doc);
                doc = disi.nextDoc();
            }
            return this;
        }

        @Override
        public Builder setIndexInterval(int indexInterval) {
            return (Builder)super.setIndexInterval(indexInterval);
        }

        @Override
        public WAH8DocIdSet build() {
            if (this.wordNum != -1) {
                this.addWord(this.wordNum, (byte)this.word);
            }
            return super.build();
        }
    }

    static class WordBuilder {
        final GrowableByteArrayDataOutput out = new GrowableByteArrayDataOutput(1024);
        final GrowableByteArrayDataOutput dirtyWords = new GrowableByteArrayDataOutput(128);
        int clean = 0;
        int lastWordNum = -1;
        int numSequences = 0;
        int indexInterval = 24;
        int cardinality = 0;
        boolean reverse;

        WordBuilder() {
        }

        public WordBuilder setIndexInterval(int indexInterval) {
            if (indexInterval < 8) {
                throw new IllegalArgumentException("indexInterval must be >= 8");
            }
            this.indexInterval = indexInterval;
            return this;
        }

        void writeHeader(boolean reverse, int cleanLength, int dirtyLength) throws IOException {
            int cleanLengthMinus2 = cleanLength - 2;
            assert (cleanLengthMinus2 >= 0);
            assert (dirtyLength >= 0);
            int token = (cleanLengthMinus2 & 3) << 4 | dirtyLength & 7;
            if (reverse) {
                token |= 0x80;
            }
            if (cleanLengthMinus2 > 3) {
                token |= 0x40;
            }
            if (dirtyLength > 7) {
                token |= 8;
            }
            this.out.writeByte((byte)token);
            if (cleanLengthMinus2 > 3) {
                this.out.writeVInt(cleanLengthMinus2 >>> 2);
            }
            if (dirtyLength > 7) {
                this.out.writeVInt(dirtyLength >>> 3);
            }
        }

        private boolean sequenceIsConsistent() {
            for (int i = 1; i < this.dirtyWords.length; ++i) {
                assert (this.dirtyWords.bytes[i - 1] != 0 || this.dirtyWords.bytes[i] != 0);
                assert (this.dirtyWords.bytes[i - 1] != -1 || this.dirtyWords.bytes[i] != -1);
            }
            return true;
        }

        void writeSequence() {
            assert (this.sequenceIsConsistent());
            try {
                this.writeHeader(this.reverse, this.clean, this.dirtyWords.length);
            }
            catch (IOException cannotHappen) {
                throw new AssertionError((Object)cannotHappen);
            }
            this.out.writeBytes(this.dirtyWords.bytes, 0, this.dirtyWords.length);
            this.dirtyWords.length = 0;
            ++this.numSequences;
        }

        void addWord(int wordNum, byte word) {
            assert (wordNum > this.lastWordNum);
            assert (word != 0);
            if (!this.reverse) {
                if (this.lastWordNum == -1) {
                    this.clean = 2 + wordNum;
                    this.dirtyWords.writeByte(word);
                } else {
                    switch (wordNum - this.lastWordNum) {
                        case 1: {
                            if (word == -1 && this.dirtyWords.bytes[this.dirtyWords.length - 1] == -1) {
                                --this.dirtyWords.length;
                                this.writeSequence();
                                this.reverse = true;
                                this.clean = 2;
                                break;
                            }
                            this.dirtyWords.writeByte(word);
                            break;
                        }
                        case 2: {
                            this.dirtyWords.writeByte((byte)0);
                            this.dirtyWords.writeByte(word);
                            break;
                        }
                        default: {
                            this.writeSequence();
                            this.clean = wordNum - this.lastWordNum - 1;
                            this.dirtyWords.writeByte(word);
                            break;
                        }
                    }
                }
            } else {
                assert (this.lastWordNum >= 0);
                switch (wordNum - this.lastWordNum) {
                    case 1: {
                        if (word == -1) {
                            if (this.dirtyWords.length == 0) {
                                ++this.clean;
                                break;
                            }
                            if (this.dirtyWords.bytes[this.dirtyWords.length - 1] == -1) {
                                --this.dirtyWords.length;
                                this.writeSequence();
                                this.clean = 2;
                                break;
                            }
                            this.dirtyWords.writeByte(word);
                            break;
                        }
                        this.dirtyWords.writeByte(word);
                        break;
                    }
                    case 2: {
                        this.dirtyWords.writeByte((byte)0);
                        this.dirtyWords.writeByte(word);
                        break;
                    }
                    default: {
                        this.writeSequence();
                        this.reverse = false;
                        this.clean = wordNum - this.lastWordNum - 1;
                        this.dirtyWords.writeByte(word);
                    }
                }
            }
            this.lastWordNum = wordNum;
            this.cardinality += BitUtil.bitCount(word);
        }

        public WAH8DocIdSet build() {
            PackedLongValues indexPositions;
            PackedLongValues indexWordNums;
            if (this.cardinality == 0) {
                assert (this.lastWordNum == -1);
                return EMPTY;
            }
            this.writeSequence();
            byte[] data = Arrays.copyOf(this.out.bytes, this.out.length);
            int valueCount = (this.numSequences - 1) / this.indexInterval + 1;
            if (valueCount <= 1) {
                indexPositions = indexWordNums = SINGLE_ZERO;
            } else {
                int pageSize = 128;
                PackedLongValues.Builder positions = PackedLongValues.monotonicBuilder(128, 0.0f);
                PackedLongValues.Builder wordNums = PackedLongValues.monotonicBuilder(128, 0.0f);
                positions.add(0L);
                wordNums.add(0L);
                Iterator it = new Iterator(data, this.cardinality, Integer.MAX_VALUE, SINGLE_ZERO, SINGLE_ZERO);
                assert (it.in.getPosition() == 0);
                assert (it.wordNum == -1);
                for (int i = 1; i < valueCount; ++i) {
                    for (int j = 0; j < this.indexInterval; ++j) {
                        boolean readSequence = it.readSequence();
                        assert (readSequence);
                        it.skipDirtyBytes();
                    }
                    int position = it.in.getPosition();
                    int wordNum = it.wordNum;
                    positions.add(position);
                    wordNums.add(wordNum + 1);
                }
                indexPositions = positions.build();
                indexWordNums = wordNums.build();
            }
            return new WAH8DocIdSet(data, this.cardinality, this.indexInterval, indexPositions, indexWordNums);
        }
    }
}

