/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.DataOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ArrayUtil;

public final class GrowableByteArrayDataOutput
extends DataOutput {
    public byte[] bytes;
    public int length;

    public GrowableByteArrayDataOutput(int cp) {
        this.bytes = new byte[ArrayUtil.oversize(cp, 1)];
        this.length = 0;
    }

    @Override
    public void writeByte(byte b) {
        if (this.length >= this.bytes.length) {
            this.bytes = ArrayUtil.grow(this.bytes);
        }
        this.bytes[this.length++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) {
        int newLength = this.length + len;
        this.bytes = ArrayUtil.grow(this.bytes, newLength);
        System.arraycopy(b, off, this.bytes, this.length, len);
        this.length = newLength;
    }
}

