/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ThreadInterruptedException;

public abstract class RateLimiter {
    public abstract void setMbPerSec(double var1);

    public abstract double getMbPerSec();

    public abstract long pause(long var1);

    public abstract long getMinPauseCheckBytes();

    public static class SimpleRateLimiter
    extends RateLimiter {
        private static final int MIN_PAUSE_CHECK_MSEC = 5;
        private volatile double mbPerSec;
        private volatile long minPauseCheckBytes;
        private long lastNS;

        public SimpleRateLimiter(double mbPerSec) {
            this.setMbPerSec(mbPerSec);
            this.lastNS = System.nanoTime();
        }

        @Override
        public void setMbPerSec(double mbPerSec) {
            this.mbPerSec = mbPerSec;
            this.minPauseCheckBytes = (long)(0.005 * mbPerSec * 1024.0 * 1024.0);
        }

        @Override
        public long getMinPauseCheckBytes() {
            return this.minPauseCheckBytes;
        }

        @Override
        public double getMbPerSec() {
            return this.mbPerSec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long pause(long bytes) {
            long pauseNS;
            long targetNS;
            long startNS = System.nanoTime();
            double secondsToPause = (double)bytes / 1024.0 / 1024.0 / this.mbPerSec;
            SimpleRateLimiter simpleRateLimiter = this;
            synchronized (simpleRateLimiter) {
                targetNS = this.lastNS + (long)(1.0E9 * secondsToPause);
                if (startNS >= targetNS) {
                    this.lastNS = startNS;
                    return 0L;
                }
                this.lastNS = targetNS;
            }
            long curNS = startNS;
            while ((pauseNS = targetNS - curNS) > 0L) {
                try {
                    int sleepNS;
                    int sleepMS;
                    if (pauseNS > 214748364700000L) {
                        sleepMS = Integer.MAX_VALUE;
                        sleepNS = 0;
                    } else {
                        sleepMS = (int)(pauseNS / 1000000L);
                        sleepNS = (int)(pauseNS % 1000000L);
                    }
                    Thread.sleep(sleepMS, sleepNS);
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
                curNS = System.nanoTime();
            }
            return curNS - startNS;
        }
    }
}

