/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.RateLimiter;

final class RateLimitedIndexOutput
extends IndexOutput {
    private final IndexOutput delegate;
    private final RateLimiter rateLimiter;
    private long bytesSinceLastPause;
    private long currentMinPauseCheckBytes;

    RateLimitedIndexOutput(RateLimiter rateLimiter, IndexOutput delegate) {
        this.delegate = delegate;
        this.rateLimiter = rateLimiter;
        this.currentMinPauseCheckBytes = rateLimiter.getMinPauseCheckBytes();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long getFilePointer() {
        return this.delegate.getFilePointer();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.delegate.getChecksum();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        ++this.bytesSinceLastPause;
        this.checkRate();
        this.delegate.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.bytesSinceLastPause += (long)length;
        this.checkRate();
        this.delegate.writeBytes(b, offset, length);
    }

    private void checkRate() {
        if (this.bytesSinceLastPause > this.currentMinPauseCheckBytes) {
            this.rateLimiter.pause(this.bytesSinceLastPause);
            this.bytesSinceLastPause = 0L;
            this.currentMinPauseCheckBytes = this.rateLimiter.getMinPauseCheckBytes();
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }
}

