/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.FilterDirectory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.RateLimiter;

public final class RateLimitedDirectoryWrapper
extends FilterDirectory {
    private volatile RateLimiter[] contextRateLimiters = new RateLimiter[IOContext.Context.values().length];

    public RateLimitedDirectoryWrapper(Directory wrapped) {
        super(wrapped);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        IndexOutput output = super.createOutput(name, context);
        RateLimiter limiter = this.getRateLimiter(context.context);
        if (limiter != null) {
            return new RateLimitedIndexOutput(limiter, output);
        }
        return output;
    }

    @Override
    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.ensureOpen();
        this.in.copy(to, src, dest, context);
    }

    private RateLimiter getRateLimiter(IOContext.Context context) {
        assert (context != null);
        return this.contextRateLimiters[context.ordinal()];
    }

    public void setMaxWriteMBPerSec(Double mbPerSec, IOContext.Context context) {
        this.ensureOpen();
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        int ord = context.ordinal();
        RateLimiter limiter = this.contextRateLimiters[ord];
        if (mbPerSec == null) {
            if (limiter != null) {
                limiter.setMbPerSec(Double.MAX_VALUE);
                this.contextRateLimiters[ord] = null;
            }
        } else if (limiter != null) {
            limiter.setMbPerSec(mbPerSec);
            this.contextRateLimiters[ord] = limiter;
        } else {
            this.contextRateLimiters[ord] = new RateLimiter.SimpleRateLimiter(mbPerSec);
        }
    }

    public void setRateLimiter(RateLimiter mergeWriteRateLimiter, IOContext.Context context) {
        this.ensureOpen();
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        this.contextRateLimiters[context.ordinal()] = mergeWriteRateLimiter;
    }

    public Double getMaxWriteMBPerSec(IOContext.Context context) {
        this.ensureOpen();
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        RateLimiter limiter = this.getRateLimiter(context);
        return limiter == null ? null : Double.valueOf(limiter.getMbPerSec());
    }
}

