/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Lock;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;

class NativeFSLock
extends Lock {
    private FileChannel channel;
    private FileLock lock;
    private File path;
    private File lockDir;
    private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());

    public NativeFSLock(File lockDir, String lockFileName) {
        this.lockDir = lockDir;
        this.path = new File(lockDir, lockFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean obtain() throws IOException {
        if (this.lock != null) {
            return false;
        }
        if (!this.lockDir.exists()) {
            if (!this.lockDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
            }
        } else if (!this.lockDir.isDirectory()) {
            throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
        }
        String canonicalPath = this.path.getCanonicalPath();
        boolean obtained = false;
        if (!LOCK_HELD.add(canonicalPath)) return obtained;
        try {
            this.channel = FileChannel.open(this.path.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            try {
                this.lock = this.channel.tryLock();
                if (this.lock != null) {
                    return true;
                }
                boolean bl = false;
                obtained = bl;
            }
            catch (IOException | OverlappingFileLockException e) {
                this.failureReason = e;
            }
            if (obtained) return obtained;
        }
        catch (Throwable throwable) {
            if (obtained) throw throwable;
            NativeFSLock.clearLockHeld(this.path);
            FileChannel toClose = this.channel;
            this.channel = null;
            IOUtils.closeWhileHandlingException(toClose);
            throw throwable;
        }
        NativeFSLock.clearLockHeld(this.path);
        FileChannel toClose = this.channel;
        this.channel = null;
        IOUtils.closeWhileHandlingException(toClose);
        return obtained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        block5: {
            try {
                if (this.lock == null) break block5;
                try {
                    this.lock.release();
                    this.lock = null;
                }
                finally {
                    NativeFSLock.clearLockHeld(this.path);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(this.channel);
                this.channel = null;
                throw throwable;
            }
        }
        IOUtils.close(this.channel);
        this.channel = null;
    }

    private static final void clearLockHeld(File path) throws IOException {
        boolean remove = LOCK_HELD.remove(path.getCanonicalPath());
        assert (remove) : "Lock was cleared but never marked as held";
    }

    @Override
    public synchronized boolean isLocked() {
        if (this.lock != null) {
            return true;
        }
        if (!this.path.exists()) {
            return false;
        }
        try {
            boolean obtained = this.obtain();
            if (obtained) {
                this.close();
            }
            return !obtained;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public String toString() {
        return "NativeFSLock@" + this.path;
    }
}

