/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.util.ShapeFieldCache;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;

public abstract class ShapeFieldCacheProvider<T extends Shape> {
    private Logger log = Logger.getLogger(this.getClass().getName());
    WeakHashMap<IndexReader, ShapeFieldCache<T>> sidx = new WeakHashMap();
    protected final int defaultSize;
    protected final String shapeField;

    public ShapeFieldCacheProvider(String shapeField, int defaultSize) {
        this.shapeField = shapeField;
        this.defaultSize = defaultSize;
    }

    protected abstract T readShape(BytesRef var1);

    public synchronized ShapeFieldCache<T> getCache(AtomicReader reader) throws IOException {
        ShapeFieldCache<T> idx = this.sidx.get(reader);
        if (idx != null) {
            return idx;
        }
        long startTime = System.currentTimeMillis();
        this.log.fine("Building Cache [" + reader.maxDoc() + "]");
        idx = new ShapeFieldCache(reader.maxDoc(), this.defaultSize);
        int count = 0;
        DocsEnum docs = null;
        Terms terms = reader.terms(this.shapeField);
        TermsEnum te = null;
        if (terms != null) {
            te = terms.iterator(te);
            BytesRef term = te.next();
            while (term != null) {
                T shape = this.readShape(term);
                if (shape != null) {
                    docs = te.docs(null, docs, 0);
                    Integer docid = docs.nextDoc();
                    while (docid != Integer.MAX_VALUE) {
                        idx.add(docid, shape);
                        docid = docs.nextDoc();
                        ++count;
                    }
                }
                term = te.next();
            }
        }
        this.sidx.put(reader, idx);
        long elapsed = System.currentTimeMillis() - startTime;
        this.log.fine("Cached: [" + count + " in " + elapsed + "ms] " + idx);
        return idx;
    }
}

