/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;

public class ShapeAreaValueSource
extends ValueSource {
    private final ValueSource shapeValueSource;
    private final SpatialContext ctx;
    private final boolean geoArea;

    public ShapeAreaValueSource(ValueSource shapeValueSource, SpatialContext ctx, boolean geoArea) {
        this.shapeValueSource = shapeValueSource;
        this.ctx = ctx;
        this.geoArea = geoArea;
    }

    @Override
    public String description() {
        return "area(" + this.shapeValueSource.description() + ",geo=" + this.geoArea + ")";
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.shapeValueSource.createWeight(context, searcher);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.shapeValueSource.getValues(context, readerContext);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) {
                Shape shape = (Shape)shapeValues.objectVal(doc);
                if (shape == null || shape.isEmpty()) {
                    return 0.0;
                }
                return shape.getArea(ShapeAreaValueSource.this.geoArea ? ShapeAreaValueSource.this.ctx : null);
            }

            @Override
            public boolean exists(int doc) {
                return shapeValues.exists(doc);
            }

            @Override
            public Explanation explain(int doc) {
                Explanation exp = super.explain(doc);
                exp.addDetail(shapeValues.explain(doc));
                return exp;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeAreaValueSource that = (ShapeAreaValueSource)o;
        if (this.geoArea != that.geoArea) {
            return false;
        }
        return this.shapeValueSource.equals(that.shapeValueSource);
    }

    @Override
    public int hashCode() {
        int result = this.shapeValueSource.hashCode();
        result = 31 * result + (this.geoArea ? 1 : 0);
        return result;
    }
}

