/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree.Cell;

public abstract class SpatialPrefixTree {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;
    protected final int maxLevels;
    protected final SpatialContext ctx;
    private transient Cell worldCell;

    public SpatialPrefixTree(SpatialContext ctx, int maxLevels) {
        assert (maxLevels > 0);
        this.ctx = ctx;
        this.maxLevels = maxLevels;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(maxLevels:" + this.maxLevels + ",ctx:" + this.ctx + ")";
    }

    public abstract int getLevelForDistance(double var1);

    public double getDistanceForLevel(int level) {
        if (level < 1 || level > this.getMaxLevels()) {
            throw new IllegalArgumentException("Level must be in 1 to maxLevels range");
        }
        Cell cell = this.getCell(this.ctx.getWorldBounds().getCenter(), level);
        Rectangle bbox = cell.getShape().getBoundingBox();
        double width = bbox.getWidth();
        double height = bbox.getHeight();
        return Math.sqrt(width * width + height * height);
    }

    public Cell getWorldCell() {
        if (this.worldCell == null) {
            this.worldCell = this.getCell("");
        }
        return this.worldCell;
    }

    public abstract Cell getCell(String var1);

    public abstract Cell getCell(byte[] var1, int var2, int var3);

    public final Cell getCell(byte[] bytes, int offset, int len, Cell target) {
        if (target == null) {
            return this.getCell(bytes, offset, len);
        }
        target.reset(bytes, offset, len);
        return target;
    }

    protected Cell getCell(Point p, int level) {
        return this.getCells(p, level, false).get(0);
    }

    public List<Cell> getCells(Shape shape, int detailLevel, boolean inclParents, boolean simplify) {
        if (detailLevel > this.maxLevels) {
            throw new IllegalArgumentException("detailLevel > maxLevels");
        }
        if (shape instanceof Point) {
            return this.getCells((Point)shape, detailLevel, inclParents);
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(inclParents ? 4096 : 2048);
        this.recursiveGetCells(this.getWorldCell(), shape, detailLevel, inclParents, simplify, cells);
        return cells;
    }

    private boolean recursiveGetCells(Cell cell, Shape shape, int detailLevel, boolean inclParents, boolean simplify, List<Cell> result) {
        if (cell.getLevel() == detailLevel) {
            cell.setLeaf();
        }
        if (cell.isLeaf()) {
            result.add(cell);
            return true;
        }
        if (inclParents && cell.getLevel() != 0) {
            result.add(cell);
        }
        Collection<Cell> subCells = cell.getSubCells(shape);
        int leaves = 0;
        for (Cell subCell : subCells) {
            if (!this.recursiveGetCells(subCell, shape, detailLevel, inclParents, simplify, result)) continue;
            ++leaves;
        }
        if (simplify && leaves == cell.getSubCellsSize() && cell.getLevel() != 0) {
            do {
                result.remove(result.size() - 1);
            } while (--leaves > 0);
            cell.setLeaf();
            if (!inclParents) {
                result.add(cell);
            }
            return true;
        }
        return false;
    }

    public List<Cell> getCells(Point p, int detailLevel, boolean inclParents) {
        Cell cell = this.getCell(p, detailLevel);
        if (!inclParents) {
            return Collections.singletonList(cell);
        }
        String endToken = cell.getTokenString();
        assert (endToken.length() == detailLevel);
        ArrayList<Cell> cells = new ArrayList<Cell>(detailLevel);
        for (int i = 1; i < detailLevel; ++i) {
            cells.add(this.getCell(endToken.substring(0, i)));
        }
        cells.add(cell);
        return cells;
    }

    public static List<String> cellsToTokenStrings(Collection<Cell> cells) {
        ArrayList<String> tokens = new ArrayList<String>(cells.size());
        for (Cell cell : cells) {
            String token = cell.getTokenString();
            if (cell.isLeaf()) {
                tokens.add(token + '+');
                continue;
            }
            tokens.add(token);
        }
        return tokens;
    }
}

