/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io.GeohashUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;

public class GeohashPrefixTree
extends SpatialPrefixTree {
    public GeohashPrefixTree(SpatialContext ctx, int maxLevels) {
        super(ctx, maxLevels);
        Rectangle bounds = ctx.getWorldBounds();
        if (bounds.getMinX() != -180.0) {
            throw new IllegalArgumentException("Geohash only supports lat-lon world bounds. Got " + bounds);
        }
        int MAXP = GeohashPrefixTree.getMaxLevelsPossible();
        if (maxLevels <= 0 || maxLevels > MAXP) {
            throw new IllegalArgumentException("maxLen must be [1-" + MAXP + "] but got " + maxLevels);
        }
    }

    public static int getMaxLevelsPossible() {
        return 24;
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        int level = GeohashUtils.lookupHashLenForWidthHeight(dist, dist);
        return Math.max(Math.min(level, this.maxLevels), 1);
    }

    @Override
    public Cell getCell(Point p, int level) {
        return new GhCell(GeohashUtils.encodeLatLon(p.getY(), p.getX(), level));
    }

    @Override
    public Cell getCell(String token) {
        return new GhCell(token);
    }

    @Override
    public Cell getCell(byte[] bytes, int offset, int len) {
        return new GhCell(bytes, offset, len);
    }

    class GhCell
    extends Cell {
        private Shape shape;

        GhCell(String token) {
            super(token);
        }

        GhCell(byte[] bytes, int off, int len) {
            super(bytes, off, len);
        }

        @Override
        public void reset(byte[] bytes, int off, int len) {
            super.reset(bytes, off, len);
            this.shape = null;
        }

        @Override
        public Collection<Cell> getSubCells() {
            String[] hashes = GeohashUtils.getSubGeohashes(this.getGeohash());
            ArrayList<Cell> cells = new ArrayList<Cell>(hashes.length);
            for (String hash : hashes) {
                cells.add(new GhCell(hash));
            }
            return cells;
        }

        @Override
        public int getSubCellsSize() {
            return 32;
        }

        @Override
        public Cell getSubCell(Point p) {
            return GeohashPrefixTree.this.getCell(p, this.getLevel() + 1);
        }

        @Override
        public Shape getShape() {
            if (this.shape == null) {
                this.shape = GeohashUtils.decodeBoundary(this.getGeohash(), GeohashPrefixTree.this.ctx);
            }
            return this.shape;
        }

        @Override
        public Point getCenter() {
            return GeohashUtils.decode(this.getGeohash(), GeohashPrefixTree.this.ctx);
        }

        private String getGeohash() {
            return this.getTokenString();
        }
    }

    public static class Factory
    extends SpatialPrefixTreeFactory {
        @Override
        protected int getLevelForDistance(double degrees) {
            GeohashPrefixTree grid = new GeohashPrefixTree(this.ctx, GeohashPrefixTree.getMaxLevelsPossible());
            return grid.getLevelForDistance(degrees);
        }

        @Override
        protected SpatialPrefixTree newSPT() {
            return new GeohashPrefixTree(this.ctx, this.maxLevels != null ? this.maxLevels : GeohashPrefixTree.getMaxLevelsPossible());
        }
    }
}

