/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix;

import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.TermsFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;

public class TermQueryPrefixTreeStrategy
extends PrefixTreeStrategy {
    public TermQueryPrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName, false);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (op != SpatialOperation.Intersects) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        List<Cell> cells = this.grid.getCells(shape, detailLevel, false, true);
        BytesRef[] terms = new BytesRef[cells.size()];
        int i = 0;
        for (Cell cell : cells) {
            terms[i++] = new BytesRef(cell.getTokenString());
        }
        return new TermsFilter(this.getFieldName(), terms);
    }
}

