/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.bbox;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.spatial.bbox.BBoxSimilarityValueSource;

public class BBoxOverlapRatioValueSource
extends BBoxSimilarityValueSource {
    private final boolean isGeo;
    private final Rectangle queryExtent;
    private final double queryArea;
    private final double minSideLength;
    private final double queryTargetProportion;

    public BBoxOverlapRatioValueSource(ValueSource rectValueSource, boolean isGeo, Rectangle queryExtent, double queryTargetProportion, double minSideLength) {
        super(rectValueSource);
        this.isGeo = isGeo;
        this.minSideLength = minSideLength;
        this.queryExtent = queryExtent;
        this.queryArea = this.calcArea(queryExtent.getWidth(), queryExtent.getHeight());
        assert (this.queryArea >= 0.0);
        this.queryTargetProportion = queryTargetProportion;
        if (queryTargetProportion < 0.0 || queryTargetProportion > 1.0) {
            throw new IllegalArgumentException("queryTargetProportion must be >= 0 and <= 1");
        }
    }

    public BBoxOverlapRatioValueSource(ValueSource rectValueSource, Rectangle queryExtent) {
        this(rectValueSource, true, queryExtent, 0.25, 0.0);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BBoxOverlapRatioValueSource that = (BBoxOverlapRatioValueSource)o;
        if (Double.compare(that.minSideLength, this.minSideLength) != 0) {
            return false;
        }
        if (Double.compare(that.queryTargetProportion, this.queryTargetProportion) != 0) {
            return false;
        }
        return this.queryExtent.equals(that.queryExtent);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queryExtent.hashCode();
        long temp = Double.doubleToLongBits(this.minSideLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.queryTargetProportion);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    protected String similarityDescription() {
        return this.queryExtent.toString() + "," + this.queryTargetProportion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected double score(Rectangle target, Explanation exp) {
        double targetRatio;
        double bottom;
        double top = Math.min(this.queryExtent.getMaxY(), target.getMaxY());
        double height = top - (bottom = Math.max(this.queryExtent.getMinY(), target.getMinY()));
        if (height < 0.0) {
            return 0.0;
        }
        double width = 0.0;
        Rectangle a = this.queryExtent;
        Rectangle b = target;
        if (a.getCrossesDateLine() == b.getCrossesDateLine()) {
            double left = Math.max(a.getMinX(), b.getMinX());
            double right = Math.min(a.getMaxX(), b.getMaxX());
            if (!a.getCrossesDateLine()) {
                if (left <= right) {
                    width = right - left;
                } else {
                    if (!this.isGeo || Math.abs(a.getMinX()) != 180.0 && Math.abs(a.getMaxX()) != 180.0 || Math.abs(b.getMinX()) != 180.0 && Math.abs(b.getMaxX()) != 180.0) return 0.0;
                    width = 0.0;
                }
            } else {
                width = right - left + 360.0;
            }
        } else {
            double qryEastRight;
            double qryEastLeft;
            double qryWestRight;
            double qryWestLeft;
            if (!a.getCrossesDateLine()) {
                a = target;
                b = this.queryExtent;
            }
            if ((qryWestLeft = Math.max(a.getMinX(), b.getMinX())) < (qryWestRight = b.getMaxX())) {
                width += qryWestRight - qryWestLeft;
            }
            if ((qryEastLeft = b.getMinX()) < (qryEastRight = Math.min(a.getMaxX(), b.getMaxX()))) {
                width += qryEastRight - qryEastLeft;
            }
            if (qryWestLeft > qryWestRight && qryEastLeft > qryEastRight) {
                return 0.0;
            }
        }
        double intersectionArea = this.calcArea(width, height);
        double queryRatio = this.queryArea > 0.0 ? intersectionArea / this.queryArea : (this.queryExtent.getHeight() > 0.0 ? height / this.queryExtent.getHeight() : (this.queryExtent.getWidth() > 0.0 ? width / this.queryExtent.getWidth() : (this.queryExtent.relate(target).intersects() ? 1.0 : 0.0)));
        double targetArea = this.calcArea(target.getWidth(), target.getHeight());
        assert (targetArea >= 0.0);
        if (targetArea > 0.0) {
            targetRatio = intersectionArea / targetArea;
        } else if (target.getHeight() > 0.0) {
            targetRatio = height / target.getHeight();
        } else if (target.getWidth() > 0.0) {
            targetRatio = width / target.getWidth();
        } else {
            double d = targetRatio = target.relate(this.queryExtent).intersects() ? 1.0 : 0.0;
        }
        assert (queryRatio >= 0.0 && queryRatio <= 1.0) : queryRatio;
        assert (targetRatio >= 0.0 && targetRatio <= 1.0) : targetRatio;
        double queryFactor = queryRatio * this.queryTargetProportion;
        double targetFactor = targetRatio * (1.0 - this.queryTargetProportion);
        double score = queryFactor + targetFactor;
        if (exp == null) return score;
        exp.setValue((float)score);
        exp.setDescription(this.getClass().getSimpleName() + ": queryFactor + targetFactor");
        String minSideDesc = this.minSideLength > 0.0 ? " (minSide=" + this.minSideLength + ")" : "";
        Explanation e = new Explanation((float)intersectionArea, "IntersectionArea" + minSideDesc);
        exp.addDetail(e);
        e.addDetail(new Explanation((float)width, "width"));
        e.addDetail(new Explanation((float)height, "height"));
        e.addDetail(new Explanation((float)this.queryTargetProportion, "queryTargetProportion"));
        e = new Explanation((float)queryFactor, "queryFactor");
        exp.addDetail(e);
        e.addDetail(new Explanation((float)queryRatio, "ratio"));
        e.addDetail(new Explanation((float)this.queryArea, "area of " + this.queryExtent + minSideDesc));
        e = new Explanation((float)targetFactor, "targetFactor");
        exp.addDetail(e);
        e.addDetail(new Explanation((float)targetRatio, "ratio"));
        e.addDetail(new Explanation((float)targetArea, "area of " + target + minSideDesc));
        return score;
    }

    private double calcArea(double width, double height) {
        return Math.max(this.minSideLength, width) * Math.max(this.minSideLength, height);
    }
}

