/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.vectorhighlight;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.vectorhighlight.FieldTermStack;

public class WeightedFieldFragList
extends FieldFragList {
    public WeightedFieldFragList(int fragCharSize) {
        super(fragCharSize);
    }

    @Override
    public void add(int startOffset, int endOffset, List<FieldPhraseList.WeightedPhraseInfo> phraseInfoList) {
        ArrayList<FieldFragList.WeightedFragInfo.SubInfo> tempSubInfos = new ArrayList<FieldFragList.WeightedFragInfo.SubInfo>();
        ArrayList<FieldFragList.WeightedFragInfo.SubInfo> realSubInfos = new ArrayList<FieldFragList.WeightedFragInfo.SubInfo>();
        HashSet<String> distinctTerms = new HashSet<String>();
        int length = 0;
        for (FieldPhraseList.WeightedPhraseInfo phraseInfo : phraseInfoList) {
            float phraseTotalBoost = 0.0f;
            for (FieldTermStack.TermInfo ti : phraseInfo.getTermsInfos()) {
                if (distinctTerms.add(ti.getText())) {
                    phraseTotalBoost += ti.getWeight() * phraseInfo.getBoost();
                }
                ++length;
            }
            tempSubInfos.add(new FieldFragList.WeightedFragInfo.SubInfo(phraseInfo.getText(), phraseInfo.getTermsOffsets(), phraseInfo.getSeqnum(), phraseTotalBoost));
        }
        float norm = (float)length * (1.0f / (float)Math.sqrt(length));
        float totalBoost = 0.0f;
        for (FieldFragList.WeightedFragInfo.SubInfo tempSubInfo : tempSubInfos) {
            float subInfoBoost = tempSubInfo.getBoost() * norm;
            realSubInfos.add(new FieldFragList.WeightedFragInfo.SubInfo(tempSubInfo.getText(), tempSubInfo.getTermsOffsets(), tempSubInfo.getSeqnum(), subInfoBoost));
            totalBoost += subInfoBoost;
        }
        this.getFragInfos().add(new FieldFragList.WeightedFragInfo(startOffset, endOffset, realSubInfos, totalBoost));
    }
}

