/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IntsRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.automaton.Transition;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.FST;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.fst.Util;

public class FSTUtil {
    private FSTUtil() {
    }

    public static <T> List<Path<T>> intersectPrefixPaths(Automaton a, FST<T> fst) throws IOException {
        assert (a.isDeterministic());
        ArrayList queue = new ArrayList();
        ArrayList<Path<T>> endNodes = new ArrayList<Path<T>>();
        if (a.getNumStates() == 0) {
            return endNodes;
        }
        queue.add(new Path<T>(0, fst.getFirstArc(new FST.Arc()), fst.outputs.getNoOutput(), new IntsRefBuilder()));
        FST.Arc scratchArc = new FST.Arc();
        FST.BytesReader fstReader = fst.getBytesReader();
        Transition t = new Transition();
        while (queue.size() != 0) {
            Path path = (Path)queue.remove(queue.size() - 1);
            if (a.isAccept(path.state)) {
                endNodes.add(path);
                continue;
            }
            IntsRefBuilder currentInput = path.input;
            int count = a.initTransition(path.state, t);
            for (int i = 0; i < count; ++i) {
                IntsRefBuilder newInput;
                FST.Arc<T> nextArc;
                a.getNextTransition(t);
                int min = t.min;
                int max = t.max;
                if (min == max) {
                    nextArc = fst.findTargetArc(t.min, path.fstNode, scratchArc, fstReader);
                    if (nextArc == null) continue;
                    newInput = new IntsRefBuilder();
                    newInput.copyInts(currentInput.get());
                    newInput.append(t.min);
                    queue.add(new Path(t.dest, new FST.Arc<T>().copyFrom(nextArc), fst.outputs.add(path.output, nextArc.output), newInput));
                    continue;
                }
                nextArc = Util.readCeilArc(min, fst, path.fstNode, scratchArc, fstReader);
                while (nextArc != null && nextArc.label <= max) {
                    assert (nextArc.label <= max);
                    assert (nextArc.label >= min) : nextArc.label + " " + min;
                    newInput = new IntsRefBuilder();
                    newInput.copyInts(currentInput.get());
                    newInput.append(nextArc.label);
                    queue.add(new Path(t.dest, new FST.Arc<T>().copyFrom(nextArc), fst.outputs.add(path.output, nextArc.output), newInput));
                    int label = nextArc.label;
                    FST.Arc<T> arc = nextArc = nextArc.isLast() ? null : fst.readNextRealArc(nextArc, fstReader);
                    assert (nextArc == null || label < nextArc.label) : "last: " + label + " next: " + nextArc.label;
                }
            }
        }
        return endNodes;
    }

    public static final class Path<T> {
        public final int state;
        public final FST.Arc<T> fstNode;
        T output;
        public final IntsRefBuilder input;

        public Path(int state, FST.Arc<T> fstNode, T output, IntsRefBuilder input) {
            this.state = state;
            this.fstNode = fstNode;
            this.output = output;
            this.input = input;
        }
    }
}

