/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.lucene410.Lucene410Codec;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.BinaryDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.Document;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.NumericDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.StringField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.document.TextField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FilterAtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexWriterConfig;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MultiDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.sorter.EarlyTerminatingSortingCollector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.sorter.SortingMergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.PrefixQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SearcherManager;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TopFieldCollector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TopFieldDocs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest.Lookup;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.DataInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.DataOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.FSDirectory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public class AnalyzingInfixSuggester
extends Lookup
implements Closeable {
    protected static final String TEXT_FIELD_NAME = "text";
    protected static final String EXACT_TEXT_FIELD_NAME = "exacttext";
    protected static final String CONTEXTS_FIELD_NAME = "contexts";
    protected final Analyzer queryAnalyzer;
    protected final Analyzer indexAnalyzer;
    final Version matchVersion;
    private final Directory dir;
    final int minPrefixChars;
    private IndexWriter writer;
    protected SearcherManager searcherMgr;
    public static final int DEFAULT_MIN_PREFIX_CHARS = 4;
    private static final Sort SORT = new Sort(new SortField("weight", SortField.Type.LONG, true));

    public AnalyzingInfixSuggester(Version matchVersion, Directory dir, Analyzer analyzer) throws IOException {
        this(matchVersion, dir, analyzer, analyzer, 4);
    }

    public AnalyzingInfixSuggester(Version matchVersion, Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars) throws IOException {
        if (minPrefixChars < 0) {
            throw new IllegalArgumentException("minPrefixChars must be >= 0; got: " + minPrefixChars);
        }
        this.queryAnalyzer = queryAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
        this.matchVersion = matchVersion;
        this.dir = dir;
        this.minPrefixChars = minPrefixChars;
        if (DirectoryReader.indexExists(dir)) {
            this.writer = new IndexWriter(dir, this.getIndexWriterConfig(matchVersion, this.getGramAnalyzer(), IndexWriterConfig.OpenMode.APPEND));
            this.searcherMgr = new SearcherManager(this.writer, true, null);
        }
    }

    protected IndexWriterConfig getIndexWriterConfig(Version matchVersion, Analyzer indexAnalyzer, IndexWriterConfig.OpenMode openMode) {
        IndexWriterConfig iwc = new IndexWriterConfig(matchVersion, indexAnalyzer);
        iwc.setCodec(new Lucene410Codec());
        iwc.setOpenMode(openMode);
        iwc.setMergePolicy(new SortingMergePolicy(iwc.getMergePolicy(), SORT));
        return iwc;
    }

    protected Directory getDirectory(File path) throws IOException {
        return FSDirectory.open(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iter) throws IOException {
        block8: {
            Object r;
            block7: {
                if (this.searcherMgr != null) {
                    this.searcherMgr.close();
                    this.searcherMgr = null;
                }
                if (this.writer != null) {
                    this.writer.close();
                    this.writer = null;
                }
                r = null;
                boolean success = false;
                try {
                    BytesRef text;
                    this.writer = new IndexWriter(this.dir, this.getIndexWriterConfig(this.matchVersion, this.getGramAnalyzer(), IndexWriterConfig.OpenMode.CREATE));
                    while ((text = iter.next()) != null) {
                        BytesRef payload = iter.hasPayloads() ? iter.payload() : null;
                        this.add(text, iter.contexts(), iter.weight(), payload);
                    }
                    this.searcherMgr = new SearcherManager(this.writer, true, null);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(new Closeable[]{r});
                    } else {
                        IOUtils.closeWhileHandlingException(this.writer, r);
                        this.writer = null;
                    }
                    throw throwable;
                }
                IOUtils.close(new Closeable[]{r});
                break block8;
            }
            IOUtils.closeWhileHandlingException(this.writer, r);
            this.writer = null;
        }
    }

    private Analyzer getGramAnalyzer() {
        return new AnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return AnalyzingInfixSuggester.this.indexAnalyzer;
            }

            @Override
            protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                if (fieldName.equals("textgrams") && AnalyzingInfixSuggester.this.minPrefixChars > 0) {
                    return new Analyzer.TokenStreamComponents(components.getTokenizer(), new EdgeNGramTokenFilter(AnalyzingInfixSuggester.this.matchVersion, components.getTokenStream(), 1, AnalyzingInfixSuggester.this.minPrefixChars));
                }
                return components;
            }
        };
    }

    public void add(BytesRef text, Set<BytesRef> contexts, long weight, BytesRef payload) throws IOException {
        this.writer.addDocument(this.buildDocument(text, contexts, weight, payload));
    }

    public void update(BytesRef text, Set<BytesRef> contexts, long weight, BytesRef payload) throws IOException {
        this.writer.updateDocument(new Term(EXACT_TEXT_FIELD_NAME, text.utf8ToString()), this.buildDocument(text, contexts, weight, payload));
    }

    private Document buildDocument(BytesRef text, Set<BytesRef> contexts, long weight, BytesRef payload) throws IOException {
        String textString = text.utf8ToString();
        Document doc = new Document();
        FieldType ft = this.getTextFieldType();
        doc.add(new Field(TEXT_FIELD_NAME, textString, ft));
        doc.add(new Field("textgrams", textString, ft));
        doc.add(new StringField(EXACT_TEXT_FIELD_NAME, textString, Field.Store.NO));
        doc.add(new BinaryDocValuesField(TEXT_FIELD_NAME, text));
        doc.add(new NumericDocValuesField("weight", weight));
        if (payload != null) {
            doc.add(new BinaryDocValuesField("payloads", payload));
        }
        if (contexts != null) {
            for (BytesRef context : contexts) {
                doc.add(new StringField(CONTEXTS_FIELD_NAME, context.utf8ToString(), Field.Store.NO));
                doc.add(new SortedSetDocValuesField(CONTEXTS_FIELD_NAME, context));
            }
        }
        return doc;
    }

    public void refresh() throws IOException {
        this.searcherMgr.maybeRefreshBlocking();
    }

    protected FieldType getTextFieldType() {
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        ft.setOmitNorms(true);
        return ft;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) throws IOException {
        return this.lookup(key, contexts, num, true, true);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return this.lookup(key, null, num, allTermsRequired, doHighlight);
    }

    protected Query getLastTokenQuery(String token) throws IOException {
        if (token.length() < this.minPrefixChars) {
            return new TermQuery(new Term("textgrams", token));
        }
        return new PrefixQuery(new Term(TEXT_FIELD_NAME, token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        BooleanQuery query;
        if (this.searcherMgr == null) {
            throw new IllegalStateException("suggester was not built");
        }
        BooleanClause.Occur occur = allTermsRequired ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        TokenStream ts = null;
        HashSet<String> matchedTokens = new HashSet<String>();
        String prefixToken = null;
        try {
            ts = this.queryAnalyzer.tokenStream("", new StringReader(key.toString()));
            ts.reset();
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
            String lastToken = null;
            query = new BooleanQuery();
            int maxEndOffset = -1;
            matchedTokens = new HashSet();
            while (ts.incrementToken()) {
                if (lastToken != null) {
                    matchedTokens.add(lastToken);
                    query.add(new TermQuery(new Term(TEXT_FIELD_NAME, lastToken)), occur);
                }
                if ((lastToken = termAtt.toString()) == null) continue;
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
            }
            ts.end();
            if (lastToken != null) {
                Query lastQuery;
                if (maxEndOffset == offsetAtt.endOffset()) {
                    lastQuery = this.getLastTokenQuery(lastToken);
                    prefixToken = lastToken;
                } else {
                    matchedTokens.add(lastToken);
                    lastQuery = new TermQuery(new Term(TEXT_FIELD_NAME, lastToken));
                }
                if (lastQuery != null) {
                    query.add(lastQuery, occur);
                }
            }
            if (contexts != null) {
                BooleanQuery sub = new BooleanQuery();
                query.add(sub, BooleanClause.Occur.MUST);
                for (BytesRef context : contexts) {
                    sub.add(new TermQuery(new Term(CONTEXTS_FIELD_NAME, context.utf8ToString())), BooleanClause.Occur.SHOULD);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(ts);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(ts);
        Query finalQuery = this.finishQuery(query, allTermsRequired);
        TopFieldCollector c = TopFieldCollector.create(SORT, num, true, false, false, false);
        EarlyTerminatingSortingCollector c2 = new EarlyTerminatingSortingCollector(c, SORT, num);
        IndexSearcher searcher = (IndexSearcher)this.searcherMgr.acquire();
        List<Lookup.LookupResult> results = null;
        try {
            searcher.search(finalQuery, c2);
            TopFieldDocs hits = (TopFieldDocs)c.topDocs();
            results = this.createResults(searcher, hits, num, key, doHighlight, matchedTokens, prefixToken);
        }
        finally {
            this.searcherMgr.release(searcher);
        }
        return results;
    }

    protected List<Lookup.LookupResult> createResults(IndexSearcher searcher, TopFieldDocs hits, int num, CharSequence charSequence, boolean doHighlight, Set<String> matchedTokens, String prefixToken) throws IOException {
        BinaryDocValues textDV = MultiDocValues.getBinaryValues(searcher.getIndexReader(), TEXT_FIELD_NAME);
        BinaryDocValues payloadsDV = MultiDocValues.getBinaryValues(searcher.getIndexReader(), "payloads");
        List<AtomicReaderContext> leaves = searcher.getIndexReader().leaves();
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            HashSet<BytesRef> contexts;
            FieldDoc fd = (FieldDoc)hits.scoreDocs[i];
            BytesRef term = textDV.get(fd.doc);
            String text = term.utf8ToString();
            long score = (Long)fd.fields[0];
            BytesRef payload = payloadsDV != null ? BytesRef.deepCopyOf(payloadsDV.get(fd.doc)) : null;
            int segment = ReaderUtil.subIndex(fd.doc, leaves);
            SortedSetDocValues contextsDV = leaves.get(segment).reader().getSortedSetDocValues(CONTEXTS_FIELD_NAME);
            if (contextsDV != null) {
                long ord;
                contexts = new HashSet<BytesRef>();
                contextsDV.setDocument(fd.doc - leaves.get((int)segment).docBase);
                while ((ord = contextsDV.nextOrd()) != -1L) {
                    BytesRef context = BytesRef.deepCopyOf(contextsDV.lookupOrd(ord));
                    contexts.add(context);
                }
            } else {
                contexts = null;
            }
            Lookup.LookupResult result = doHighlight ? new Lookup.LookupResult(text, this.highlight(text, matchedTokens, prefixToken), score, payload, contexts) : new Lookup.LookupResult((CharSequence)text, score, payload, contexts);
            results.add(result);
        }
        return results;
    }

    protected Query finishQuery(BooleanQuery in, boolean allTermsRequired) {
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object highlight(String text, Set<String> matchedTokens, String prefixToken) throws IOException {
        String string;
        TokenStream ts = this.queryAnalyzer.tokenStream(TEXT_FIELD_NAME, new StringReader(text));
        try {
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
            ts.reset();
            StringBuilder sb = new StringBuilder();
            int upto = 0;
            while (ts.incrementToken()) {
                String token = termAtt.toString();
                int startOffset = offsetAtt.startOffset();
                int endOffset = offsetAtt.endOffset();
                if (upto < startOffset) {
                    this.addNonMatch(sb, text.substring(upto, startOffset));
                    upto = startOffset;
                } else if (upto > startOffset) continue;
                if (matchedTokens.contains(token)) {
                    this.addWholeMatch(sb, text.substring(startOffset, endOffset), token);
                    upto = endOffset;
                    continue;
                }
                if (prefixToken == null || !token.startsWith(prefixToken)) continue;
                this.addPrefixMatch(sb, text.substring(startOffset, endOffset), token, prefixToken);
                upto = endOffset;
            }
            ts.end();
            int endOffset = offsetAtt.endOffset();
            if (upto < endOffset) {
                this.addNonMatch(sb, text.substring(upto));
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(ts);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(ts);
        return string;
    }

    protected void addNonMatch(StringBuilder sb, String text) {
        sb.append(text);
    }

    protected void addWholeMatch(StringBuilder sb, String surface, String analyzed) {
        sb.append("<b>");
        sb.append(surface);
        sb.append("</b>");
    }

    protected void addPrefixMatch(StringBuilder sb, String surface, String analyzed, String prefixToken) {
        if (prefixToken.length() >= surface.length()) {
            this.addWholeMatch(sb, surface, analyzed);
            return;
        }
        sb.append("<b>");
        sb.append(surface.substring(0, prefixToken.length()));
        sb.append("</b>");
        sb.append(surface.substring(prefixToken.length()));
    }

    @Override
    public boolean store(DataOutput in) throws IOException {
        return false;
    }

    @Override
    public boolean load(DataInput out) throws IOException {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.searcherMgr != null) {
            this.searcherMgr.close();
            this.searcherMgr = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.dir.close();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        long mem = RamUsageEstimator.shallowSizeOf(this);
        try {
            if (this.searcherMgr != null) {
                IndexSearcher searcher = (IndexSearcher)this.searcherMgr.acquire();
                try {
                    for (AtomicReaderContext context : searcher.getIndexReader().leaves()) {
                        AtomicReader reader = FilterAtomicReader.unwrap(context.reader());
                        if (!(reader instanceof SegmentReader)) continue;
                        mem += ((SegmentReader)context.reader()).ramBytesUsed();
                    }
                }
                finally {
                    this.searcherMgr.release(searcher);
                }
            }
            return mem;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCount() throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.searcherMgr.acquire();
        try {
            long l = searcher.getIndexReader().numDocs();
            return l;
        }
        finally {
            this.searcherMgr.release(searcher);
        }
    }
}

