/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.OfflineSorter;

public class SortedTermFreqIteratorWrapper
implements TermFreqIterator {
    private final TermFreqIterator source;
    private File tempInput;
    private File tempSorted;
    private final OfflineSorter.ByteSequencesReader reader;
    private final Comparator<BytesRef> comparator;
    private boolean done = false;
    private long weight;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final Comparator<BytesRef> tieBreakByCostComparator = new Comparator<BytesRef>(){
        private final BytesRef leftScratch = new BytesRef();
        private final BytesRef rightScratch = new BytesRef();
        private final ByteArrayDataInput input = new ByteArrayDataInput();

        @Override
        public int compare(BytesRef left, BytesRef right) {
            this.leftScratch.bytes = left.bytes;
            this.leftScratch.offset = left.offset;
            this.leftScratch.length = left.length;
            this.rightScratch.bytes = right.bytes;
            this.rightScratch.offset = right.offset;
            this.rightScratch.length = right.length;
            long leftCost = SortedTermFreqIteratorWrapper.this.decode(this.leftScratch, this.input);
            long rightCost = SortedTermFreqIteratorWrapper.this.decode(this.rightScratch, this.input);
            int cmp = SortedTermFreqIteratorWrapper.this.comparator.compare(this.leftScratch, this.rightScratch);
            if (cmp != 0) {
                return cmp;
            }
            return Long.compare(leftCost, rightCost);
        }
    };

    public SortedTermFreqIteratorWrapper(TermFreqIterator source) throws IOException {
        this(source, BytesRef.getUTF8SortedAsUnicodeComparator());
    }

    public SortedTermFreqIteratorWrapper(TermFreqIterator source, Comparator<BytesRef> comparator) throws IOException {
        this.source = source;
        this.comparator = comparator;
        this.reader = this.sort();
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRef next() throws IOException {
        boolean success = false;
        if (this.done) {
            return null;
        }
        try {
            ByteArrayDataInput input = new ByteArrayDataInput();
            if (this.reader.read(this.scratch)) {
                this.weight = this.decode(this.scratch.get(), input);
                success = true;
                BytesRef bytesRef = this.scratch.get();
                return bytesRef;
            }
            this.close();
            this.done = true;
            success = true;
            BytesRef bytesRef = null;
            return bytesRef;
        }
        finally {
            if (!success) {
                this.done = true;
                this.close();
            }
        }
    }

    @Override
    public long weight() {
        return this.weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfflineSorter.ByteSequencesReader sort() throws IOException {
        OfflineSorter.ByteSequencesReader byteSequencesReader;
        block12: {
            OfflineSorter.ByteSequencesWriter writer;
            block11: {
                String prefix = this.getClass().getSimpleName();
                File directory = OfflineSorter.defaultTempDir();
                this.tempInput = File.createTempFile(prefix, ".input", directory);
                this.tempSorted = File.createTempFile(prefix, ".sorted", directory);
                writer = new OfflineSorter.ByteSequencesWriter(this.tempInput);
                boolean success = false;
                try {
                    BytesRef spare;
                    byte[] buffer = new byte[]{};
                    ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
                    while ((spare = this.source.next()) != null) {
                        this.encode(writer, output, buffer, spare, this.source.weight());
                    }
                    writer.close();
                    new OfflineSorter(this.tieBreakByCostComparator).sort(this.tempInput, this.tempSorted);
                    OfflineSorter.ByteSequencesReader reader = new OfflineSorter.ByteSequencesReader(this.tempSorted);
                    success = true;
                    byteSequencesReader = reader;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(writer);
                    } else {
                        try {
                            IOUtils.closeWhileHandlingException(writer);
                        }
                        finally {
                            this.close();
                        }
                    }
                    throw throwable;
                }
                IOUtils.close(writer);
                break block12;
            }
            try {
                IOUtils.closeWhileHandlingException(writer);
            }
            finally {
                this.close();
            }
        }
        return byteSequencesReader;
    }

    private void close() throws IOException {
        IOUtils.close(this.reader);
        if (this.tempInput != null) {
            this.tempInput.delete();
        }
        if (this.tempSorted != null) {
            this.tempSorted.delete();
        }
    }

    protected void encode(OfflineSorter.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, long weight) throws IOException {
        if (spare.length + 8 >= buffer.length) {
            buffer = ArrayUtil.grow(buffer, spare.length + 8);
        }
        output.reset(buffer);
        output.writeBytes(spare.bytes, spare.offset, spare.length);
        output.writeLong(weight);
        writer.write(buffer, 0, output.getPosition());
    }

    protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes);
        tmpInput.skipBytes(scratch.length - 8);
        scratch.length -= 8;
        return tmpInput.readLong();
    }
}

