/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell.Dictionary;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;

public class FileDictionary
implements Dictionary {
    public static final String DEFAULT_FIELD_DELIMITER = "\t";
    private BufferedReader in;
    private String line;
    private boolean done = false;
    private final String fieldDelimiter;

    public FileDictionary(InputStream dictFile) {
        this(dictFile, DEFAULT_FIELD_DELIMITER);
    }

    public FileDictionary(Reader reader) {
        this(reader, DEFAULT_FIELD_DELIMITER);
    }

    public FileDictionary(Reader reader, String fieldDelimiter) {
        this.in = new BufferedReader(reader);
        this.fieldDelimiter = fieldDelimiter;
    }

    public FileDictionary(InputStream dictFile, String fieldDelimiter) {
        this.in = new BufferedReader(IOUtils.getDecodingReader(dictFile, StandardCharsets.UTF_8));
        this.fieldDelimiter = fieldDelimiter;
    }

    @Override
    public InputIterator getEntryIterator() {
        try {
            return new FileIterator();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    final class FileIterator
    implements InputIterator {
        private long curWeight;
        private final BytesRefBuilder spare = new BytesRefBuilder();
        private BytesRefBuilder curPayload = new BytesRefBuilder();
        private boolean isFirstLine = true;
        private boolean hasPayloads = false;

        private FileIterator() throws IOException {
            FileDictionary.this.line = FileDictionary.this.in.readLine();
            if (FileDictionary.this.line == null) {
                FileDictionary.this.done = true;
                IOUtils.close(FileDictionary.this.in);
            } else {
                String[] fields = FileDictionary.this.line.split(FileDictionary.this.fieldDelimiter);
                if (fields.length > 3) {
                    throw new IllegalArgumentException("More than 3 fields in one line");
                }
                if (fields.length == 3) {
                    this.hasPayloads = true;
                    this.spare.copyChars(fields[0]);
                    this.readWeight(fields[1]);
                    this.curPayload.copyChars(fields[2]);
                } else if (fields.length == 2) {
                    this.spare.copyChars(fields[0]);
                    this.readWeight(fields[1]);
                } else {
                    this.spare.copyChars(fields[0]);
                    this.curWeight = 1L;
                }
            }
        }

        @Override
        public long weight() {
            return this.curWeight;
        }

        @Override
        public BytesRef next() throws IOException {
            if (FileDictionary.this.done) {
                return null;
            }
            if (this.isFirstLine) {
                this.isFirstLine = false;
                return this.spare.get();
            }
            FileDictionary.this.line = FileDictionary.this.in.readLine();
            if (FileDictionary.this.line != null) {
                String[] fields = FileDictionary.this.line.split(FileDictionary.this.fieldDelimiter);
                if (fields.length > 3) {
                    throw new IllegalArgumentException("More than 3 fields in one line");
                }
                if (fields.length == 3) {
                    this.spare.copyChars(fields[0]);
                    this.readWeight(fields[1]);
                    if (this.hasPayloads) {
                        this.curPayload.copyChars(fields[2]);
                    }
                } else if (fields.length == 2) {
                    this.spare.copyChars(fields[0]);
                    this.readWeight(fields[1]);
                    if (this.hasPayloads) {
                        this.curPayload = new BytesRefBuilder();
                    }
                } else {
                    this.spare.copyChars(fields[0]);
                    this.curWeight = 1L;
                    if (this.hasPayloads) {
                        this.curPayload = new BytesRefBuilder();
                    }
                }
                return this.spare.get();
            }
            FileDictionary.this.done = true;
            IOUtils.close(FileDictionary.this.in);
            return null;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return null;
        }

        @Override
        public BytesRef payload() {
            return this.hasPayloads ? this.curPayload.get() : null;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        private void readWeight(String weight) {
            try {
                this.curWeight = Long.parseLong(weight);
            }
            catch (NumberFormatException e) {
                this.curWeight = (long)Double.parseDouble(weight);
            }
        }

        @Override
        public Set<BytesRef> contexts() {
            return null;
        }

        @Override
        public boolean hasContexts() {
            return false;
        }
    }
}

